/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.bin;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import plantmegapack.PlantMegaPack;
import plantmegapack.block.PMPBlockBambooBlock;
import plantmegapack.block.PMPBlockBambooDoor;
import plantmegapack.block.PMPBlockBambooFence;
import plantmegapack.block.PMPBlockBambooGate;
import plantmegapack.block.PMPBlockBambooLadder;
import plantmegapack.block.PMPBlockBambooPole;
import plantmegapack.block.PMPBlockBambooSlab;
import plantmegapack.block.PMPBlockBambooStairs;
import plantmegapack.block.PMPBlockHangingPlant;
import plantmegapack.block.PMPBlockPlant;
import plantmegapack.block.PMPBlockWallBracket;
import plantmegapack.common.PMPFlowerColor;
import plantmegapack.common.PMPHangingPlant;
import plantmegapack.common.PMPModInfo;
import plantmegapack.common.PMPPlant;
import plantmegapack.common.PMPPlantCategory;
import plantmegapack.common.PMPTab;
import plantmegapack.common.PMPWallBracket;
import plantmegapack.data.PMPDataPlant;
import plantmegapack.item.PMPItemBambooSlab;

public class PMPBlocks {
    private ArrayList<PMPBlockHangingPlant> hangingPlants = new ArrayList(PMPHangingPlant.values().length);
    private Map<PMPPlantCategory, ArrayList<PMPBlockPlant>> plantBlocks = new HashMap<PMPPlantCategory, ArrayList<PMPBlockPlant>>();
    private ArrayList<PMPBlockBambooPole> bambooPoles = new ArrayList();
    private ArrayList<PMPBlockBambooBlock> bambooBlocks = new ArrayList();
    private ArrayList<PMPBlockBambooSlab> bambooSlabs = new ArrayList();
    private ArrayList<PMPBlockBambooSlab> bambooSlabsDouble = new ArrayList();
    private ArrayList<PMPBlockBambooStairs> bambooStairs = new ArrayList();
    private ArrayList<PMPBlockBambooDoor> bambooDoors = new ArrayList();
    private ArrayList<PMPBlockBambooFence> bambooFences = new ArrayList();
    private ArrayList<PMPBlockBambooGate> bambooGates = new ArrayList();
    private ArrayList<PMPBlockBambooLadder> bambooLadders = new ArrayList();
    private ArrayList<PMPBlockWallBracket> wallBrackets = new ArrayList(PMPWallBracket.values().length);

    public PMPBlocks() {
        this.createHangingPlants();
        this.createPlantBlockArrays();
        this.createPlantBlocks();
        if (PlantMegaPack.settings.contentCraftingBambooBlocks) {
            this.createBambooBlocks();
        }
        this.createWallBrackets();
    }

    private void createHangingPlants() {
        for (PMPHangingPlant plantList : PMPHangingPlant.values()) {
            PMPBlockHangingPlant block;
            if (plantList.addToGame <= 0 || (block = new PMPBlockHangingPlant(plantList.ID)) == null) continue;
            this.hangingPlants.add(block);
            PMPModInfo.addToRegisteredBlocks(1);
        }
    }

    private void createPlantBlocks() {
        for (PMPPlant plant : PMPPlant.values()) {
            if (plant.addToGame <= 0 || !this.canCreatePlant(plant)) continue;
            PMPModInfo.addToRegisteredPlants(this.createPlantBlock(plant));
        }
    }

    private void createBambooBlocks() {
        String blockName;
        int index;
        for (index = 0; index < this.getPlantBlockList(PMPPlantCategory.BAMBOO).size(); ++index) {
            blockName = this.getPlantBlockList(PMPPlantCategory.BAMBOO).get(index).func_149739_a().substring(5);
            PMPBlockBambooPole blockPole = new PMPBlockBambooPole(blockName + "Pole");
            if (blockPole == null) continue;
            this.bambooPoles.add(blockPole);
            OreDictionary.registerOre((String)("poleB" + blockName.substring(1)), (Block)blockPole);
            CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(new ItemStack(Item.func_150898_a((Block)blockPole), 1, 0), new Object[]{new ItemStack(Item.func_150898_a((Block)this.getPlantBlock(blockName)), 1, 0)}));
            PMPModInfo.addToRegisteredBlocks(1);
            PMPModInfo.addToRegisteredRecipes(1);
        }
        for (index = 0; index < this.getPlantBlockList(PMPPlantCategory.BAMBOO).size(); ++index) {
            blockName = this.getPlantBlockList(PMPPlantCategory.BAMBOO).get(index).func_149739_a().substring(5);
            PMPBlockBambooBlock block = new PMPBlockBambooBlock(blockName + "Block", this.getPlantBlockList(PMPPlantCategory.BAMBOO).get(index));
            if (block == null) continue;
            this.bambooBlocks.add(block);
            OreDictionary.registerOre((String)("blockB" + blockName.substring(1)), (Block)block);
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(Item.func_150898_a((Block)block), 2, 0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack(Item.func_150898_a((Block)this.bambooPoles.get(index)), 1, 0)}));
            PMPModInfo.addToRegisteredBlocks(1);
            PMPModInfo.addToRegisteredRecipes(1);
        }
        for (index = 0; index < this.getPlantBlockList(PMPPlantCategory.BAMBOO).size(); ++index) {
            blockName = this.getPlantBlockList(PMPPlantCategory.BAMBOO).get(index).func_149739_a().substring(5);
            PMPBlockBambooStairs blockStairs = new PMPBlockBambooStairs(blockName + "Stairs", this.bambooBlocks.get(index));
            if (blockStairs == null) continue;
            this.bambooStairs.add(blockStairs);
            OreDictionary.registerOre((String)("stairsB" + blockName.substring(1)), (Block)blockStairs);
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(Item.func_150898_a((Block)blockStairs), 4, 0), new Object[]{"  x", " xx", "xxx", Character.valueOf('x'), new ItemStack(Item.func_150898_a((Block)((Block)this.bambooBlocks.get(index))), 1, 0)}));
            PMPModInfo.addToRegisteredBlocks(1);
            PMPModInfo.addToRegisteredRecipes(1);
        }
        for (index = 0; index < this.getPlantBlockList(PMPPlantCategory.BAMBOO).size(); ++index) {
            blockName = this.getPlantBlockList(PMPPlantCategory.BAMBOO).get(index).func_149739_a().substring(5);
            PMPBlockBambooSlab blockSlab = new PMPBlockBambooSlab(false, blockName + "Slab", this.bambooBlocks.get(index));
            PMPBlockBambooSlab blockSlabDouble = new PMPBlockBambooSlab(true, blockName + "SlabDouble", this.bambooBlocks.get(index));
            if (blockSlab == null || blockSlabDouble == null) continue;
            this.bambooSlabs.add(blockSlab);
            this.bambooSlabsDouble.add(blockSlabDouble);
            GameRegistry.registerBlock((Block)blockSlab, PMPItemBambooSlab.class, (String)(blockName + "Slab"), (Object[])new Object[]{blockSlab, blockSlabDouble});
            GameRegistry.registerBlock((Block)blockSlabDouble, PMPItemBambooSlab.class, (String)(blockName + "SlabDouble"), (Object[])new Object[]{blockSlab, blockSlabDouble});
            OreDictionary.registerOre((String)("blockB" + blockName.substring(1) + "Slab"), (Block)blockSlab);
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(Item.func_150898_a((Block)blockSlab), 6, 0), new Object[]{"   ", "xxx", "   ", Character.valueOf('x'), new ItemStack(Item.func_150898_a((Block)((Block)this.bambooBlocks.get(index))), 1, 0)}));
            PMPModInfo.addToRegisteredBlocks(1);
            PMPModInfo.addToRegisteredRecipes(1);
        }
        for (index = 0; index < this.getPlantBlockList(PMPPlantCategory.BAMBOO).size(); ++index) {
            blockName = this.getPlantBlockList(PMPPlantCategory.BAMBOO).get(index).func_149739_a().substring(5);
            PMPBlockBambooDoor blockDoor = new PMPBlockBambooDoor(blockName + "Door");
            if (blockDoor == null) continue;
            this.bambooDoors.add(blockDoor);
            OreDictionary.registerOre((String)("doorB" + blockName.substring(1)), (Block)blockDoor);
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(Item.func_150898_a((Block)blockDoor), 3, 0), new Object[]{"xx ", "xx ", "xx ", Character.valueOf('x'), new ItemStack(Item.func_150898_a((Block)((Block)this.bambooBlocks.get(index))), 1, 0)}));
            PMPModInfo.addToRegisteredBlocks(1);
            PMPModInfo.addToRegisteredRecipes(1);
        }
        for (index = 0; index < this.getPlantBlockList(PMPPlantCategory.BAMBOO).size(); ++index) {
            blockName = this.getPlantBlockList(PMPPlantCategory.BAMBOO).get(index).func_149739_a().substring(5);
            PMPBlockBambooFence blockFence = new PMPBlockBambooFence(blockName + "Fence", this.bambooBlocks.get(index));
            if (blockFence == null) continue;
            this.bambooFences.add(blockFence);
            OreDictionary.registerOre((String)("fenceB" + blockName.substring(1)), (Block)blockFence);
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(Item.func_150898_a((Block)blockFence), 3, 0), new Object[]{"   ", "xyx", "xyx", Character.valueOf('x'), new ItemStack(Item.func_150898_a((Block)((Block)this.bambooBlocks.get(index))), 1, 0), Character.valueOf('y'), new ItemStack(Item.func_150898_a((Block)this.bambooPoles.get(index)), 1, 0)}));
            PMPModInfo.addToRegisteredBlocks(1);
            PMPModInfo.addToRegisteredRecipes(1);
        }
        for (index = 0; index < this.getPlantBlockList(PMPPlantCategory.BAMBOO).size(); ++index) {
            blockName = this.getPlantBlockList(PMPPlantCategory.BAMBOO).get(index).func_149739_a().substring(5);
            PMPBlockBambooGate blockGate = new PMPBlockBambooGate(blockName + "Gate", this.bambooBlocks.get(index));
            if (blockGate == null) continue;
            this.bambooGates.add(blockGate);
            OreDictionary.registerOre((String)("gateB" + blockName.substring(1)), (Block)blockGate);
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(Item.func_150898_a((Block)blockGate), 1, 0), new Object[]{"   ", "xyx", "xyx", Character.valueOf('x'), new ItemStack(Item.func_150898_a((Block)this.bambooPoles.get(index)), 1, 0), Character.valueOf('y'), new ItemStack(Item.func_150898_a((Block)((Block)this.bambooBlocks.get(index))), 1, 0)}));
            PMPModInfo.addToRegisteredBlocks(1);
            PMPModInfo.addToRegisteredRecipes(1);
        }
        for (index = 0; index < this.getPlantBlockList(PMPPlantCategory.BAMBOO).size(); ++index) {
            blockName = this.getPlantBlockList(PMPPlantCategory.BAMBOO).get(index).func_149739_a().substring(5);
            PMPBlockBambooLadder blockLadder = new PMPBlockBambooLadder(blockName + "Ladder", this.bambooBlocks.get(index));
            if (blockLadder == null) continue;
            this.bambooLadders.add(blockLadder);
            OreDictionary.registerOre((String)("ladderB" + blockName.substring(1)), (Block)blockLadder);
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(Item.func_150898_a((Block)blockLadder), 3, 0), new Object[]{"x x", "xxx", "x x", Character.valueOf('x'), new ItemStack(Item.func_150898_a((Block)this.bambooPoles.get(index)), 1, 0)}));
            PMPModInfo.addToRegisteredBlocks(1);
            PMPModInfo.addToRegisteredRecipes(1);
        }
    }

    private void createWallBrackets() {
        for (PMPWallBracket bracketList : PMPWallBracket.values()) {
            PMPBlockWallBracket block;
            if (bracketList.ID.startsWith("wallBracketBamboo") && !PlantMegaPack.settings.contentCraftingBambooBlocks || !bracketList.alwaysCreate && !PlantMegaPack.settings.contentWallBracketExtra || (block = new PMPBlockWallBracket(bracketList.ID, bracketList.renderType)) == null) continue;
            this.wallBrackets.add(block);
            OreDictionary.registerOre((String)bracketList.ID, (Block)block);
            PMPModInfo.addToRegisteredBlocks(1);
            PMPModInfo.addToRegisteredRecipes(1);
        }
    }

    private void createPlantBlockArrays() {
        for (PMPPlantCategory category : PMPPlantCategory.values()) {
            ArrayList list;
            if (category.addToGame <= 0 || !this.canCreateCategory(category) || (list = new ArrayList()) == null) continue;
            this.plantBlocks.put(category, list);
        }
    }

    private boolean canCreatePlant(PMPPlant plant) {
        return this.canCreateCategory(plant.category);
    }

    private boolean canCreateCategory(PMPPlantCategory category) {
        if (!PlantMegaPack.settings.contentAquatic && category.creativeTab == PMPTab.aquatic) {
            return false;
        }
        return PlantMegaPack.settings.contentCrops || category.creativeTab != PMPTab.crops;
    }

    private int createPlantBlock(PMPPlant plant) {
        int blocksAdded = 0;
        PMPDataPlant plantData = new PMPDataPlant(plant);
        if (plantData != null) {
            plantData.loadUserConfig();
            PMPBlockPlant plantBlock = new PMPBlockPlant(plantData);
            if (plantBlock != null) {
                this.getPlantBlockList(plant.category).add(plantBlock);
                if (plantData.attributes.category == PMPPlantCategory.FLOATING && plantBlock.hasFlowerColors()) {
                    plantBlock.colorMap = new ArrayList();
                    if (plantBlock.colorMap != null) {
                        int index = 0;
                        for (PMPFlowerColor color : PMPFlowerColor.values()) {
                            if (plantData.attributes.plantData.charAt(color.ordinal()) != '1') continue;
                            plantBlock.colorMap.add(color);
                            CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(new ItemStack(Items.field_151100_aR, 1, color.dyeColor), new Object[]{new ItemStack((Block)plantBlock, 1, index)}));
                            ++index;
                            PMPModInfo.addToRegisteredRecipes(1);
                        }
                        blocksAdded += plantBlock.colorMap.size();
                    }
                } else if (plantData.attributes.category == PMPPlantCategory.FLOWER_MULTI) {
                    plantBlock.colorMap = new ArrayList();
                    if (plantBlock.colorMap != null) {
                        int index = 0;
                        for (PMPFlowerColor color : PMPFlowerColor.values()) {
                            if (plantData.attributes.plantData.charAt(color.ordinal()) != '1') continue;
                            plantBlock.colorMap.add(color);
                            CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(new ItemStack(Items.field_151100_aR, 1, color.dyeColor), new Object[]{new ItemStack((Block)plantBlock, 1, index)}));
                            CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack((Block)this.getHangingPlantBlock(color.hangingPlant.ID), 1, 0), new Object[]{" x ", " y ", " z ", Character.valueOf('x'), new ItemStack(Items.field_151042_j, 1, 0), Character.valueOf('y'), new ItemStack((Block)plantBlock, 1, index), Character.valueOf('z'), new ItemStack(Items.field_151054_z, 1, 0)}));
                            ++index;
                            PMPModInfo.addToRegisteredRecipes(2);
                        }
                        blocksAdded += plantBlock.colorMap.size();
                    }
                } else {
                    if (plantData.attributes.category != PMPPlantCategory.CORAL && plantBlock.plantData.attributes.dyeColor >= 0) {
                        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(new ItemStack(Items.field_151100_aR, 1, plantBlock.plantData.attributes.dyeColor), new Object[]{new ItemStack((Block)plantBlock, 1)}));
                        PMPModInfo.addToRegisteredRecipes(1);
                    }
                    if (plantBlock.plantData.attributes.hangingPlant.length() > 0) {
                        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(Item.func_150898_a((Block)this.getHangingPlantBlock(plantBlock.plantData.attributes.hangingPlant)), 1, 0), new Object[]{" x ", " y ", " z ", Character.valueOf('x'), new ItemStack(Items.field_151042_j, 1, 0), Character.valueOf('y'), new ItemStack((Block)plantBlock, 1, 0), Character.valueOf('z'), new ItemStack(Items.field_151054_z, 1, 0)}));
                        PMPModInfo.addToRegisteredRecipes(1);
                    }
                    ++blocksAdded;
                }
            }
        }
        return blocksAdded;
    }

    public ArrayList<PMPBlockPlant> getPlantBlockList(PMPPlantCategory category) {
        return this.plantBlocks.get((Object)category);
    }

    public PMPBlockHangingPlant getHangingPlantBlock(String name) {
        for (int plantIndex = 0; plantIndex < this.hangingPlants.size(); ++plantIndex) {
            if (!name.matches(this.hangingPlants.get(plantIndex).func_149739_a().substring(5))) continue;
            return this.hangingPlants.get(plantIndex);
        }
        return null;
    }

    public PMPBlockPlant getPlantBlock(String name) {
        for (PMPPlantCategory category : PMPPlantCategory.values()) {
            if (category.addToGame <= 0 || !this.canCreateCategory(category)) continue;
            for (int plantIndex = 0; plantIndex < this.plantBlocks.get((Object)category).size(); ++plantIndex) {
                if (!this.plantBlocks.get((Object)((Object)category)).get((int)plantIndex).plantData.attributes.ID.matches(name)) continue;
                return this.plantBlocks.get((Object)category).get(plantIndex);
            }
        }
        return null;
    }

    public PMPBlockBambooBlock getBambooBlock(String name) {
        for (int index = 0; index < this.bambooBlocks.size(); ++index) {
            if (!this.bambooBlocks.get(index).func_149739_a().substring(5).matches(name)) continue;
            return this.bambooBlocks.get(index);
        }
        return null;
    }

    public PMPBlockBambooPole getBambooPole(String name) {
        for (int index = 0; index < this.bambooPoles.size(); ++index) {
            if (!this.bambooPoles.get(index).func_149739_a().substring(5).matches(name)) continue;
            return this.bambooPoles.get(index);
        }
        return null;
    }

    public PMPBlockBambooSlab getBambooSlab(String name) {
        for (int index = 0; index < this.bambooSlabs.size(); ++index) {
            if (!this.bambooSlabs.get(index).func_149739_a().substring(5).matches(name)) continue;
            return this.bambooSlabs.get(index);
        }
        return null;
    }

    public PMPBlockBambooSlab getBambooSlabDouble(String name) {
        for (int index = 0; index < this.bambooSlabsDouble.size(); ++index) {
            if (!this.bambooSlabsDouble.get(index).func_149739_a().substring(5).matches(name)) continue;
            return this.bambooSlabsDouble.get(index);
        }
        return null;
    }

    public PMPBlockBambooDoor getBambooDoor(String name) {
        for (int index = 0; index < this.bambooDoors.size(); ++index) {
            if (!this.bambooDoors.get(index).func_149739_a().substring(5).matches(name)) continue;
            return this.bambooDoors.get(index);
        }
        return null;
    }

    public PMPBlockBambooStairs getBambooStairs(String unlocalizedName) {
        for (int index = 0; index < this.bambooStairs.size(); ++index) {
            if (!this.bambooStairs.get(index).func_149739_a().substring(5).matches(unlocalizedName)) continue;
            return this.bambooStairs.get(index);
        }
        return null;
    }

    public PMPBlockBambooFence getBambooFence(String unlocalizedName) {
        for (int index = 0; index < this.bambooFences.size(); ++index) {
            if (!this.bambooFences.get(index).func_149739_a().substring(5).matches(unlocalizedName)) continue;
            return this.bambooFences.get(index);
        }
        return null;
    }

    public PMPBlockBambooGate getBambooGate(String unlocalizedName) {
        for (int index = 0; index < this.bambooGates.size(); ++index) {
            if (!this.bambooGates.get(index).func_149739_a().substring(5).matches(unlocalizedName)) continue;
            return this.bambooGates.get(index);
        }
        return null;
    }

    public PMPBlockBambooLadder getBambooLadder(String unlocalizedName) {
        for (int index = 0; index < this.bambooLadders.size(); ++index) {
            if (!this.bambooLadders.get(index).func_149739_a().substring(5).matches(unlocalizedName)) continue;
            return this.bambooLadders.get(index);
        }
        return null;
    }

    public PMPBlockWallBracket getWallBracketBlock(String name) {
        for (int index = 0; index < this.wallBrackets.size(); ++index) {
            if (!this.wallBrackets.get(index).func_149739_a().substring(5).matches(name)) continue;
            return this.wallBrackets.get(index);
        }
        return null;
    }

    public void addPlantNamesToArray(PMPPlantCategory category, ArrayList<String> array) {
        for (int index = 0; index < this.plantBlocks.get((Object)category).size(); ++index) {
            array.add(this.plantBlocks.get((Object)category).get(index).func_149739_a().substring(5));
        }
    }

    public PMPBlockPlant getRandomCoralReefPlant(Random random) {
        ArrayList<PMPBlockPlant> plantList = random.nextInt(100) < 70 ? this.getPlantBlockList(PMPPlantCategory.CORAL) : this.getPlantBlockList(PMPPlantCategory.SALTWATER);
        if (plantList == null) {
            return null;
        }
        return plantList.get(random.nextInt(plantList.size()));
    }
}

