/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPCreativeTabs;
import plantmegapack.bin.PMPEventHandlers;
import plantmegapack.bin.PMPIntegration;
import plantmegapack.bin.PMPItems;
import plantmegapack.bin.PMPRecipes;
import plantmegapack.bin.PMPRenderers;
import plantmegapack.bin.PMPSettings;
import plantmegapack.bin.PMPSoilBlocks;
import plantmegapack.common.PMPModInfo;
import plantmegapack.worldgen.PMPWorldGenerator;

@Mod(modid="plantmegapack", name="Plant Mega Pack", version="4.33", canBeDeactivated=false, guiFactory="plantmegapack.gui.PMPGuiConfig")
public class PlantMegaPack {
    public static final String MOD_ID = "plantmegapack";
    public static final String MOD_NAME = "Plant Mega Pack";
    public static final String MOD_VERSION = "4.33";
    @Mod.Instance(value="plantmegapack")
    public static PlantMegaPack instance;
    private static final Logger logger;
    public static final boolean debugMode = false;
    public static String configPathRoot;
    public static PMPSettings settings;
    public static PMPSoilBlocks soilBlocks;
    public static PMPCreativeTabs creativeTabs;
    public static PMPBlocks blocks;
    public static PMPItems items;
    public static PMPRecipes recipes;
    public static PMPWorldGenerator worldGenerator;
    public static PMPRenderers renderers;
    public static PMPEventHandlers eventHandlers;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configPathRoot = new String(event.getModConfigurationDirectory().getPath() + "/" + MOD_ID + "/");
        settings = new PMPSettings(configPathRoot);
        soilBlocks = new PMPSoilBlocks(configPathRoot);
        creativeTabs = new PMPCreativeTabs();
        blocks = new PMPBlocks();
        items = new PMPItems();
        recipes = new PMPRecipes();
        renderers = new PMPRenderers();
        worldGenerator = new PMPWorldGenerator();
        eventHandlers = new PMPEventHandlers();
        FMLCommonHandler.instance().bus().register((Object)eventHandlers);
        MinecraftForge.EVENT_BUS.register((Object)eventHandlers);
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenerator, (int)1023);
        PMPModInfo.outputModStatisticsToConsole();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PMPIntegration.initModIntegration();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    public void logOutput(String line) {
        logger.info(line);
    }

    static {
        logger = LogManager.getLogger((String)"PlantMegaPack");
    }
}

