/*
 * Decompiled with CFR 0.152.
 */
package pmp.worldgen.tree;

import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import pmp.block.BlockTreeFruit;
import pmp.core.def.DefTree;

public abstract class GenTreeBase
extends WorldGenAbstractTree {
    protected DefTree defTree;
    protected IBlockState stateLog;
    protected IBlockState stateLeaves;
    protected IBlockState stateTreeFruit;
    protected int height;
    protected int addRandomHeight;

    protected GenTreeBase(DefTree defTree, boolean notify) {
        super(notify);
        this.defTree = defTree;
        this.stateLog = Blocks.field_150364_r.func_176223_P();
        this.stateLeaves = Blocks.field_150362_t.func_176223_P();
        this.stateTreeFruit = null;
        this.height = 5;
        this.addRandomHeight = 2;
    }

    public final IBlockState getLogState() {
        return this.stateLog;
    }

    public final IBlockState getLeavesState() {
        return this.stateLeaves;
    }

    protected boolean canTreeGrowAtPos(World world, BlockPos pos) {
        BlockPos posSoil = pos.func_177977_b();
        IBlockState state = world.func_180495_p(posSoil);
        if (state.func_177230_c() == Blocks.field_150458_ak) {
            return false;
        }
        if (this.defTree.canGrowOnSand && state.func_185904_a() == Material.field_151595_p) {
            return true;
        }
        return state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, posSoil, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
    }

    protected void spawnFruit(World world, BlockPos pos) {
        if (this.stateTreeFruit == null || !(this.stateTreeFruit.func_177230_c() instanceof BlockTreeFruit)) {
            return;
        }
        world.func_180501_a(pos, this.stateTreeFruit.func_177226_a((IProperty)BlockTreeFruit.AGE, (Comparable)Integer.valueOf(7)), 2);
    }

    protected void generateTrunk(World world, BlockPos pos) {
        for (int x = 0; x < this.height; ++x) {
            world.func_180501_a(pos.func_177967_a(EnumFacing.UP, x), this.stateLog, 3);
        }
    }

    protected void generateFruitwoodTrunk(World world, BlockPos pos) {
        for (int x = 0; x < this.height; ++x) {
            world.func_180501_a(pos.func_177967_a(EnumFacing.UP, x), this.stateLog, 3);
        }
    }

    protected void generateDoubleTrunk(World world, BlockPos pos) {
        BlockPos posStart = pos;
        IBlockState woodBlockState = this.stateLog;
        for (int i = 0; i < this.height; ++i) {
            world.func_180501_a(posStart, woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.SOUTH, 1), woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.EAST, 1), woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.EAST, 1).func_177967_a(EnumFacing.SOUTH, 1), woodBlockState, 3);
            posStart = posStart.func_177967_a(EnumFacing.UP, 1);
        }
    }

    protected void generateQuadTrunk(World world, BlockPos pos) {
        BlockPos posStart = pos;
        IBlockState woodBlockState = this.stateLog;
        for (int i = 0; i < this.height; ++i) {
            world.func_180501_a(posStart, woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.NORTH, 1), woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.NORTH, 1).func_177967_a(EnumFacing.EAST, 1), woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.WEST, 1), woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.EAST, 1), woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.EAST, 2), woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.SOUTH, 1).func_177967_a(EnumFacing.WEST, 1), woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.SOUTH, 1), woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.SOUTH, 1).func_177967_a(EnumFacing.EAST, 1), woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.SOUTH, 1).func_177967_a(EnumFacing.EAST, 2), woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.SOUTH, 2), woodBlockState, 3);
            world.func_180501_a(posStart.func_177967_a(EnumFacing.SOUTH, 2).func_177967_a(EnumFacing.EAST, 1), woodBlockState, 3);
            posStart = posStart.func_177967_a(EnumFacing.UP, 1);
        }
    }

    protected BlockPos offsetToBranchStartLocation(World world, Random random, EnumFacing direction, BlockPos posStart) {
        BlockPos posNew = posStart;
        switch (direction) {
            case NORTH: {
                posNew = posStart.func_177967_a(EnumFacing.NORTH, 1);
                if (random.nextInt(100) >= 50) break;
                posNew = posNew.func_177967_a(EnumFacing.EAST, 1);
                break;
            }
            case SOUTH: {
                posNew = posStart.func_177967_a(EnumFacing.SOUTH, 2);
                if (random.nextInt(100) >= 50) break;
                posNew = posNew.func_177967_a(EnumFacing.EAST, 1);
                break;
            }
            case EAST: {
                posNew = posStart.func_177967_a(EnumFacing.EAST, 2);
                if (random.nextInt(100) >= 50) break;
                posNew = posNew.func_177967_a(EnumFacing.SOUTH, 1);
                break;
            }
            case WEST: {
                posNew = posStart.func_177967_a(EnumFacing.WEST, 1);
                if (random.nextInt(100) >= 50) break;
                posNew = posNew.func_177967_a(EnumFacing.SOUTH, 1);
                break;
            }
        }
        return posNew;
    }

    protected void generateAngledBranch(World world, BlockPos pos, EnumFacing direction, int nodes) {
        for (int i = 1; i <= nodes; ++i) {
            world.func_180501_a(pos.func_177967_a(EnumFacing.UP, i).func_177967_a(direction, i), this.stateLog, 3);
        }
    }

    protected void generateAngledBranchWithLeaves(World world, BlockPos pos, EnumFacing direction, int nodes) {
        for (int i = 1; i <= nodes; ++i) {
            BlockPos posStart = pos.func_177967_a(EnumFacing.UP, i).func_177967_a(direction, i);
            world.func_180501_a(posStart, this.stateLog, 3);
            this.spawnLeafBlock(world, posStart.func_177967_a(EnumFacing.NORTH, 1));
            this.spawnLeafBlock(world, posStart.func_177967_a(EnumFacing.SOUTH, 1));
            this.spawnLeafBlock(world, posStart.func_177967_a(EnumFacing.EAST, 1));
            this.spawnLeafBlock(world, posStart.func_177967_a(EnumFacing.WEST, 1));
            this.spawnLeafBlock(world, posStart.func_177967_a(EnumFacing.UP, 1));
        }
    }

    protected void generateHorizontalBranch(World world, BlockPos pos, EnumFacing direction, int nodes) {
        IBlockState stateLogHorz = direction == EnumFacing.NORTH || direction == EnumFacing.SOUTH ? this.stateLog.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z) : (direction == EnumFacing.WEST || direction == EnumFacing.EAST ? this.stateLog.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X) : this.stateLog.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
        for (int i = 0; i < nodes; ++i) {
            BlockPos posStart = pos.func_177967_a(direction, i);
            world.func_180501_a(posStart, stateLogHorz, 3);
        }
    }

    protected void generateAngledBranchWithLeavesSegment(World world, BlockPos pos) {
        world.func_180501_a(pos, this.stateLog, 3);
        this.spawnLeafBlock(world, pos.func_177967_a(EnumFacing.NORTH, 1));
        this.spawnLeafBlock(world, pos.func_177967_a(EnumFacing.SOUTH, 1));
        this.spawnLeafBlock(world, pos.func_177967_a(EnumFacing.EAST, 1));
        this.spawnLeafBlock(world, pos.func_177967_a(EnumFacing.WEST, 1));
    }

    protected void generateAngledBranchLeaves(World world, BlockPos pos, EnumFacing direction, int nodes, boolean outerTipLeaf) {
        BlockPos posStart = pos.func_177967_a(direction, 1).func_177967_a(EnumFacing.UP, 1);
        for (int i = 0; i < nodes; ++i) {
            this.spawnLeafBlock(world, posStart.func_177977_b());
            this.spawnLeafBlock(world, posStart.func_177984_a());
            this.spawnLeafBlock(world, posStart.func_177967_a(this.getSideDirection90(direction), 1));
            this.spawnLeafBlock(world, posStart.func_177967_a(this.getSideDirection270(direction), 1));
            posStart = posStart.func_177967_a(direction, 1).func_177984_a();
        }
        this.spawnLeafBlock(world, posStart);
        this.spawnLeafBlock(world, posStart.func_177977_b());
        if (outerTipLeaf) {
            posStart = posStart.func_177967_a(direction, 1);
            this.spawnLeafBlock(world, posStart);
        }
    }

    protected void generateBranchWithLeavesSegmented(World world, Random random, BlockPos pos, EnumFacing direction, int segments, int segmentHeight, int pctLeafGen) {
        BlockPos posStart = pos;
        for (int i = 0; i < segments; ++i) {
            for (int j = 0; j < segmentHeight; ++j) {
                world.func_180501_a(posStart, this.stateLog, 3);
                if (random.nextInt(100) < pctLeafGen) {
                    this.spawnLeafBlock(world, posStart.func_177967_a(EnumFacing.NORTH, 1));
                }
                if (random.nextInt(100) < pctLeafGen) {
                    this.spawnLeafBlock(world, posStart.func_177967_a(EnumFacing.SOUTH, 1));
                }
                if (random.nextInt(100) < pctLeafGen) {
                    this.spawnLeafBlock(world, posStart.func_177967_a(EnumFacing.EAST, 1));
                }
                if (random.nextInt(100) < pctLeafGen) {
                    this.spawnLeafBlock(world, posStart.func_177967_a(EnumFacing.WEST, 1));
                }
                posStart = posStart.func_177967_a(EnumFacing.UP, 1);
            }
            posStart = posStart.func_177967_a(direction, 1);
        }
        this.spawnLeafBlock(world, posStart.func_177967_a(direction.func_176734_d(), 1));
    }

    protected void generateDiagonalBranch(World world, BlockPos pos, EnumFacing direction1, EnumFacing direction2, int nodes) {
        for (int x = 1; x <= nodes; ++x) {
            world.func_180501_a(pos.func_177967_a(EnumFacing.UP, x).func_177967_a(direction1, x).func_177967_a(direction2, x), this.stateLog, 3);
        }
    }

    protected void generateDiagonalBranchLeaves(World world, BlockPos pos, EnumFacing direction1, EnumFacing direction2, int nodes, boolean outerTipLeaf) {
        BlockPos posStart = pos.func_177967_a(direction1, 1).func_177967_a(direction2, 1).func_177967_a(EnumFacing.UP, 1);
        for (int i = 0; i < nodes; ++i) {
            this.spawnLeafBlock(world, posStart.func_177977_b());
            this.spawnLeafBlock(world, posStart.func_177984_a());
            this.spawnLeafBlock(world, posStart.func_177978_c());
            this.spawnLeafBlock(world, posStart.func_177974_f());
            this.spawnLeafBlock(world, posStart.func_177968_d());
            this.spawnLeafBlock(world, posStart.func_177976_e());
            posStart = posStart.func_177967_a(direction1, 1).func_177967_a(direction2, 1).func_177984_a();
        }
        if (outerTipLeaf) {
            this.spawnLeafBlock(world, posStart);
        }
    }

    protected void generateLeafLayer(World world, Random random, BlockPos pos, int radius, int cornerCut, int cornerCutMissPct) {
        for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
            for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                boolean canGenerate = true;
                if (!(z != pos.func_177952_p() - radius && z != pos.func_177952_p() + radius || x >= pos.func_177958_n() - radius + cornerCut && x <= pos.func_177958_n() + radius - cornerCut || 1 + random.nextInt(99) <= cornerCutMissPct)) {
                    canGenerate = false;
                }
                if (!(x != pos.func_177958_n() - radius && x != pos.func_177958_n() + radius || z >= pos.func_177952_p() - radius + cornerCut && z <= pos.func_177952_p() + radius - cornerCut || 1 + random.nextInt(99) <= cornerCutMissPct)) {
                    canGenerate = false;
                }
                if (!canGenerate) continue;
                BlockPos newPos = new BlockPos(x, pos.func_177956_o(), z);
                this.spawnLeafBlock(world, newPos);
            }
        }
    }

    protected void generateRandomLeafLayer(World world, Random random, BlockPos pos, int radius, int cornerCut, int cornerCutMissPct, int pctChanceGenerate) {
        for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
            for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                boolean canGenerate = true;
                if (!(z != pos.func_177952_p() - radius && z != pos.func_177952_p() + radius || x >= pos.func_177958_n() - radius + cornerCut && x <= pos.func_177958_n() + radius - cornerCut || 1 + random.nextInt(99) <= cornerCutMissPct)) {
                    canGenerate = false;
                }
                if (!(x != pos.func_177958_n() - radius && x != pos.func_177958_n() + radius || z >= pos.func_177952_p() - radius + cornerCut && z <= pos.func_177952_p() + radius - cornerCut || 1 + random.nextInt(99) <= cornerCutMissPct)) {
                    canGenerate = false;
                }
                if (!canGenerate || random.nextInt(100) >= pctChanceGenerate) continue;
                BlockPos newPos = new BlockPos(x, pos.func_177956_o(), z);
                this.spawnLeafBlock(world, newPos);
            }
        }
    }

    protected void generateCircularLeafLayer(World world, Random random, BlockPos pos, int radius, int missPct) {
        for (int z = -radius; z <= radius; ++z) {
            for (int x = -radius; x <= radius; ++x) {
                if (!((float)(x * x + z * z) <= (float)(radius * radius) + (float)radius * 0.8f) || 1 + random.nextInt(100) <= missPct) continue;
                this.spawnLeafBlock(world, pos.func_177958_n() + x, pos.func_177956_o(), pos.func_177952_p() + z);
            }
        }
    }

    protected void generateSquareLeafLayer(World world, Random random, BlockPos pos, int radius, int missPct) {
        for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
            for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                if (1 + random.nextInt(100) <= missPct) continue;
                BlockPos newPos = new BlockPos(x, pos.func_177956_o(), z);
                this.spawnLeafBlock(world, newPos);
            }
        }
    }

    protected void generatePalmLeaf(World world, BlockPos pos, EnumFacing direction) {
        this.spawnLeafBlock(world, pos);
        this.spawnLeafBlock(world, pos.func_177967_a(direction, 1));
        this.spawnLeafBlock(world, pos.func_177967_a(direction, 1).func_177967_a(EnumFacing.DOWN, 1));
        this.spawnLeafBlock(world, pos.func_177967_a(direction, 2).func_177967_a(EnumFacing.DOWN, 1));
    }

    protected void generateUprightPalmLeaf(World world, BlockPos pos, EnumFacing direction) {
        this.spawnLeafBlock(world, pos);
        this.spawnLeafBlock(world, pos.func_177967_a(direction, 1));
        this.spawnLeafBlock(world, pos.func_177967_a(direction, 1).func_177967_a(EnumFacing.UP, 1));
        this.spawnLeafBlock(world, pos.func_177967_a(direction, 2).func_177967_a(EnumFacing.UP, 1));
    }

    protected void spawnLeafBlock(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        this.spawnLeafBlock(world, pos);
    }

    protected void spawnLeafBlock(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            world.func_180501_a(pos, this.stateLeaves, 3);
        }
    }

    protected EnumFacing getSideDirection90(EnumFacing direction) {
        switch (direction) {
            case NORTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.NORTH;
            }
        }
        return EnumFacing.NORTH;
    }

    protected EnumFacing getSideDirection270(EnumFacing direction) {
        switch (direction) {
            case NORTH: {
                return EnumFacing.WEST;
            }
            case EAST: {
                return EnumFacing.NORTH;
            }
            case SOUTH: {
                return EnumFacing.EAST;
            }
            case WEST: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.NORTH;
    }

    protected EnumFacing getRandomDirection(Random rand) {
        int i = 1 + rand.nextInt(100);
        if (i < 25) {
            return EnumFacing.NORTH;
        }
        if (i < 50) {
            return EnumFacing.EAST;
        }
        if (i < 75) {
            return EnumFacing.SOUTH;
        }
        return EnumFacing.WEST;
    }
}

