/*
 * Decompiled with CFR 0.152.
 */
package pmp.worldgen.tree;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pmp.PlantMegaPack;
import pmp.core.def.DefTree;
import pmp.worldgen.tree.GenTreeBase;

public class GenDkoakEverg
extends GenTreeBase {
    public GenDkoakEverg(DefTree defTree, boolean notify) {
        super(defTree, notify);
        this.stateLog = Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK);
        this.stateLeaves = PlantMegaPack.objects.getLeaves(DefTree.DKOAK_EVERG).func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (!this.canTreeGrowAtPos(world, pos)) {
            return false;
        }
        this.height = 12 + rand.nextInt(6);
        this.generateDoubleTrunk(world, pos);
        BlockPos posStart = pos.func_177967_a(EnumFacing.UP, this.height - 1);
        this.generateTrunkSpread(world, rand, posStart);
        posStart = pos.func_177967_a(EnumFacing.UP, this.height - 3);
        this.generateCanopy(world, rand, posStart);
        return true;
    }

    protected void generateTrunkSpread(World worldIn, Random random, BlockPos posStart) {
        int j = 3 + random.nextInt(4);
        BlockPos posTemp = posStart.func_177967_a(EnumFacing.NORTH, 1);
        this.spawnTrunkDownwards(worldIn, posTemp, j);
        j = 3 + random.nextInt(4);
        posTemp = posStart.func_177967_a(EnumFacing.NORTH, 1).func_177967_a(EnumFacing.EAST, 1);
        this.spawnTrunkDownwards(worldIn, posTemp, j);
        j = 3 + random.nextInt(4);
        posTemp = posStart.func_177967_a(EnumFacing.WEST, 1);
        this.spawnTrunkDownwards(worldIn, posTemp, j);
        j = 3 + random.nextInt(4);
        posTemp = posStart.func_177967_a(EnumFacing.WEST, 1).func_177967_a(EnumFacing.SOUTH, 1);
        this.spawnTrunkDownwards(worldIn, posTemp, j);
        j = 3 + random.nextInt(4);
        posTemp = posStart.func_177967_a(EnumFacing.SOUTH, 2);
        this.spawnTrunkDownwards(worldIn, posTemp, j);
        j = 3 + random.nextInt(4);
        posTemp = posStart.func_177967_a(EnumFacing.SOUTH, 2).func_177967_a(EnumFacing.EAST, 1);
        this.spawnTrunkDownwards(worldIn, posTemp, j);
        j = 3 + random.nextInt(4);
        posTemp = posStart.func_177967_a(EnumFacing.EAST, 2);
        this.spawnTrunkDownwards(worldIn, posTemp, j);
        j = 3 + random.nextInt(4);
        posTemp = posStart.func_177967_a(EnumFacing.SOUTH, 1).func_177967_a(EnumFacing.EAST, 2);
        this.spawnTrunkDownwards(worldIn, posTemp, j);
    }

    private void spawnTrunkDownwards(World worldIn, BlockPos pos, int height) {
        for (int i = 0; i < height; ++i) {
            worldIn.func_180501_a(pos.func_177967_a(EnumFacing.DOWN, i), this.stateLog, 2);
        }
    }

    protected void generateCanopy(World worldIn, Random random, BlockPos pos) {
        BlockPos posStart = pos;
        this.generateLeafLayer(worldIn, random, posStart, 2, 1, 0);
        this.generateLeafLayer(worldIn, random, posStart.func_177967_a(EnumFacing.SOUTH, 1), 2, 1, 0);
        this.generateLeafLayer(worldIn, random, posStart.func_177967_a(EnumFacing.EAST, 1), 2, 1, 0);
        this.generateLeafLayer(worldIn, random, posStart.func_177967_a(EnumFacing.SOUTH, 1).func_177967_a(EnumFacing.EAST, 1), 2, 1, 0);
        posStart = posStart.func_177967_a(EnumFacing.UP, 1);
        this.generateLeafLayer(worldIn, random, posStart, 3, 2, 0);
        this.generateLeafLayer(worldIn, random, posStart.func_177967_a(EnumFacing.SOUTH, 1), 3, 2, 0);
        this.generateLeafLayer(worldIn, random, posStart.func_177967_a(EnumFacing.EAST, 1), 3, 2, 0);
        this.generateLeafLayer(worldIn, random, posStart.func_177967_a(EnumFacing.SOUTH, 1).func_177967_a(EnumFacing.EAST, 1), 3, 2, 0);
        posStart = posStart.func_177967_a(EnumFacing.UP, 1);
        this.generateLeafLayer(worldIn, random, posStart, 3, 1, 0);
        this.generateLeafLayer(worldIn, random, posStart.func_177967_a(EnumFacing.SOUTH, 1), 3, 1, 0);
        this.generateLeafLayer(worldIn, random, posStart.func_177967_a(EnumFacing.EAST, 1), 3, 1, 0);
        this.generateLeafLayer(worldIn, random, posStart.func_177967_a(EnumFacing.SOUTH, 1).func_177967_a(EnumFacing.EAST, 1), 3, 1, 0);
        posStart = posStart.func_177967_a(EnumFacing.UP, 1);
        this.generateLeafLayer(worldIn, random, posStart, 2, 1, 0);
        this.generateLeafLayer(worldIn, random, posStart.func_177967_a(EnumFacing.SOUTH, 1), 2, 1, 0);
        this.generateLeafLayer(worldIn, random, posStart.func_177967_a(EnumFacing.EAST, 1), 2, 1, 0);
        this.generateLeafLayer(worldIn, random, posStart.func_177967_a(EnumFacing.SOUTH, 1).func_177967_a(EnumFacing.EAST, 1), 2, 1, 0);
    }
}

