/*
 * Decompiled with CFR 0.152.
 */
package pmp.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import pmp.PlantMegaPack;
import pmp.block.BlockBasePlant;
import pmp.block.BlockPlantClimbing;
import pmp.block.BlockPlantDouble;
import pmp.block.BlockPlantEpiphyte;
import pmp.core.def.DefItem;
import pmp.core.def.DefPlant;
import pmp.core.type.TypePlant;
import pmp.core.type.TypePlantCat;
import pmp.core.variant.VariantBlockHalf;
import pmp.worldgen.WorldgenHelpers;

public class GenPlantPowder {
    private static final int DEFAULT_ELEVATION = 4;
    private static final int DEFAULT_RADIUS = 3;
    private static final int MIN_ELEVATION = 1;
    private static final int MAX_ELEVATION = 6;
    private static final int MIN_RADIUS = 1;
    private static final int MAX_RADIUS = 6;

    public boolean applyPowder(World world, BlockPos pos, DefItem powder) {
        EnumParticleTypes particleType;
        int radius;
        boolean usedOnSoil;
        IBlockState stateTarget = world.func_180495_p(pos);
        boolean usedOnLeaves = WorldgenHelpers.isLeavesBlock(stateTarget);
        boolean usedOnPlant = WorldgenHelpers.isPlantBlock(stateTarget);
        boolean bl = usedOnSoil = WorldgenHelpers.isDirtBlock(stateTarget) || WorldgenHelpers.isSandBlock(stateTarget) || WorldgenHelpers.isFarmlandBlock(stateTarget);
        if (!(usedOnLeaves || usedOnPlant || usedOnSoil)) {
            return false;
        }
        switch (powder) {
            case PLNTPW_CON: {
                if (usedOnLeaves || usedOnPlant) {
                    return false;
                }
                radius = PlantMegaPack.settings.powderConditionerRadius;
                particleType = EnumParticleTypes.VILLAGER_HAPPY;
                break;
            }
            case PLNTPW_DEF: {
                radius = PlantMegaPack.settings.powderDefoliantRadius;
                particleType = EnumParticleTypes.SMOKE_LARGE;
                break;
            }
            case PLNTPW_FER: {
                if (usedOnLeaves) {
                    return false;
                }
                radius = PlantMegaPack.settings.powderFertilizerRadius;
                particleType = EnumParticleTypes.VILLAGER_HAPPY;
                break;
            }
            default: {
                return false;
            }
        }
        this.spawnParticles(world, pos, usedOnSoil, particleType);
        Random random = new Random();
        if (usedOnPlant && powder == DefItem.PLNTPW_FER) {
            this.clonePlant(world, pos, random, radius);
            return true;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int r2 = radius * radius;
        int area = r2 << 2;
        int rr = radius << 1;
        boolean blockAffected = false;
        for (int i = 0; i < area; ++i) {
            int tx = i % rr - radius;
            int tz = i / rr - radius;
            if (tx * tx + tz * tz > r2) continue;
            BlockPos posTarget = new BlockPos(x + tx, y, z + tz);
            IBlockState state = world.func_180495_p(posTarget);
            Block block = state.func_177230_c();
            if (!(WorldgenHelpers.isLeavesBlock(state) || WorldgenHelpers.isPlantBlock(state) || WorldgenHelpers.isDirtBlock(state))) {
                if ((posTarget = this.adjustForAirBlock(world, posTarget, radius)) == null) continue;
                block = world.func_180495_p(posTarget).func_177230_c();
            }
            IBlockState stateAbove = world.func_180495_p(posTarget.func_177984_a());
            if (!world.func_175623_d(posTarget.func_177984_a()) && !WorldgenHelpers.isLeavesBlock(stateAbove) && !WorldgenHelpers.isPlantBlock(stateAbove)) continue;
            switch (powder) {
                case PLNTPW_CON: {
                    blockAffected = this.applyConditionerToBlock(world, posTarget, block, random);
                    break;
                }
                case PLNTPW_DEF: {
                    blockAffected = this.applyDefoliantToBlock(world, posTarget, block, random);
                    break;
                }
                case PLNTPW_FER: {
                    blockAffected = this.applyFertilizerToBlock(world, posTarget, block, random);
                    break;
                }
                default: {
                    blockAffected = false;
                }
            }
            if (!blockAffected) continue;
            this.spawnParticles(world, posTarget, usedOnSoil, particleType);
        }
        return true;
    }

    private void spawnParticles(World world, BlockPos pos, boolean heightAdjust, EnumParticleTypes particleType) {
        Random random = new Random();
        double d0 = random.nextGaussian() * 0.02;
        double d1 = random.nextGaussian() * 0.02;
        double d2 = random.nextGaussian() * 0.02;
        double heightAdjustment = heightAdjust ? 1.0f : 0.05f;
        world.func_175688_a(particleType, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)pos.func_177956_o() + heightAdjustment + (double)random.nextFloat() * 1.0, (double)((float)pos.func_177952_p() + random.nextFloat()), d0, d1, d2, new int[0]);
    }

    private BlockPos adjustForAirBlock(World world, BlockPos pos, int elevation) {
        if (elevation < 1 || elevation > 6) {
            elevation = 4;
        }
        for (int i = 1; i <= elevation; ++i) {
            BlockPos posTarget = pos.func_177979_c(i);
            IBlockState state = world.func_180495_p(posTarget);
            if (!WorldgenHelpers.isDirtBlock(state)) continue;
            return posTarget;
        }
        return null;
    }

    private boolean applyConditionerToBlock(World world, BlockPos pos, Block block, Random random) {
        IBlockState state = world.func_180495_p(pos);
        if (WorldgenHelpers.isDirtBlock(state)) {
            world.func_180501_a(pos, Blocks.field_150458_ak.func_176223_P(), 2);
            return true;
        }
        return false;
    }

    private boolean applyDefoliantToBlock(World world, BlockPos pos, Block block, Random random) {
        IBlockState state = world.func_180495_p(pos);
        boolean applied = false;
        if (WorldgenHelpers.isDirtBlock(state) || block == Blocks.field_150458_ak) {
            world.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 2);
            applied = true;
        } else if (block == Blocks.field_150354_m && state.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.SAND) {
            world.func_180501_a(pos, Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND), 2);
            applied = true;
        } else if (WorldgenHelpers.isLeavesBlock(state)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            applied = true;
        } else if (WorldgenHelpers.isPlantBlock(state)) {
            this.destroyPlant(world, pos, random);
            return true;
        }
        if (applied) {
            this.destroyPlant(world, pos.func_177984_a(), random);
        }
        return applied;
    }

    private boolean applyFertilizerToBlock(World world, BlockPos pos, Block block, Random random) {
        IBlockState state = world.func_180495_p(pos);
        if (WorldgenHelpers.isDirtBlock(state)) {
            world.func_180501_a(pos, Blocks.field_150349_c.func_176223_P(), 2);
            return true;
        }
        if (block == Blocks.field_150391_bh) {
            world.func_180501_a(pos, Blocks.field_150349_c.func_176223_P(), 2);
            return true;
        }
        if (block == Blocks.field_150354_m && state.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND) {
            world.func_180501_a(pos, Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.SAND), 2);
            return true;
        }
        return false;
    }

    private void destroyPlant(World world, BlockPos pos, Random random) {
        BlockPos posCur = pos;
        IBlockState state = world.func_180495_p(pos);
        while (WorldgenHelpers.isPlantBlock(state)) {
            world.func_180501_a(posCur, Blocks.field_150350_a.func_176223_P(), 2);
            this.spawnParticles(world, posCur, false, EnumParticleTypes.SMOKE_LARGE);
            posCur = posCur.func_177984_a();
            state = world.func_180495_p(posCur);
        }
        posCur = pos.func_177977_b();
        state = world.func_180495_p(posCur);
        while (WorldgenHelpers.isPlantBlock(state)) {
            world.func_180501_a(posCur, Blocks.field_150350_a.func_176223_P(), 2);
            this.spawnParticles(world, posCur, false, EnumParticleTypes.SMOKE_LARGE);
            posCur = posCur.func_177977_b();
            state = world.func_180495_p(posCur);
        }
    }

    private void clonePlant(World world, BlockPos pos, Random random, int radius) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        int metaData = block.func_176201_c(state);
        if (block instanceof BlockBasePlant) {
            DefPlant plant = ((BlockBasePlant)block).defPlant;
            TypePlant plantType = plant.getPlantType();
            if (plantType.isClonable && plantType != TypePlant.EPIFL) {
                return;
            }
            if (plantType == TypePlant.DOUBL && state.func_177229_b(BlockPlantDouble.HALF) == VariantBlockHalf.TOP) {
                BlockPos posAppy = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
                this.spawnPlantRadius(world, posAppy, block, 0);
            } else if (plant.plantCategory == TypePlantCat.CLIMB) {
                this.spawnClimbingRadius(world, pos, block);
            } else if (plant.plantCategory == TypePlantCat.EPIPH && plantType == TypePlant.EPIFL) {
                this.spawnEpiphyteRadius(world, pos, block);
            } else if (plant.plantCategory == TypePlantCat.FLOWR) {
                this.spawnPlantRadius(world, pos, block, metaData);
            } else if (plant.plantCategory == TypePlantCat.BAMB) {
                this.spawnPlantRadius(world, pos, block, 4);
            } else {
                this.spawnPlantRadius(world, pos, block, 0);
            }
        } else {
            if (block instanceof BlockSapling) {
                ((BlockSapling)block).func_176478_d(world, pos, state, world.field_73012_v);
                this.spawnParticles(world, pos, false, EnumParticleTypes.VILLAGER_HAPPY);
                return;
            }
            if (state.func_185904_a() == Material.field_151570_A) {
                this.spawnPlantRadius(world, pos, block, 0);
            } else if (block instanceof BlockBush || block instanceof BlockFlower || block instanceof BlockDoublePlant || block instanceof BlockReed) {
                this.spawnPlantRadius(world, pos, block, metaData);
            }
        }
    }

    private boolean spawnClimbingRadius(World world, BlockPos pos, Block block) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockPlantClimbing) {
            return false;
        }
        BlockPlantClimbing plantBlock = (BlockPlantClimbing)block;
        while (plantBlock.func_176473_a(world, pos, world.func_180495_p(pos), world.field_72995_K)) {
            plantBlock.func_176474_b(world, world.field_73012_v, pos, world.func_180495_p(pos));
        }
        BlockPos posTarget = new BlockPos((Vec3i)pos);
        while (world.func_180495_p(posTarget).func_177230_c() instanceof BlockPlantClimbing) {
            this.spawnParticles(world, posTarget, false, EnumParticleTypes.VILLAGER_HAPPY);
            posTarget = posTarget.func_177984_a();
        }
        return true;
    }

    private boolean spawnEpiphyteRadius(World world, BlockPos pos, Block plantBlock) {
        int radius = PlantMegaPack.settings.powderFertilizerRadius / 2;
        int iy = pos.func_177956_o();
        int lowX = pos.func_177958_n() - radius / 2;
        int lowZ = pos.func_177952_p() - radius / 2;
        int highX = pos.func_177958_n() + radius / 2;
        int highZ = pos.func_177952_p() + radius / 2;
        for (int ix = lowX; ix <= highX; ++ix) {
            for (int iz = lowZ; iz <= highZ; ++iz) {
                for (int y = iy - radius; y <= iy + radius; ++y) {
                    EnumFacing direction;
                    BlockPos posNew = new BlockPos(ix, y, iz);
                    if (!world.func_175623_d(posNew) || (direction = WorldgenHelpers.isAdjacentToBlockMaterial(world, posNew, Material.field_151575_d)) == null) continue;
                    world.func_180501_a(posNew, plantBlock.func_176223_P().func_177226_a((IProperty)BlockPlantEpiphyte.FACING, (Comparable)direction.func_176734_d()), 2);
                    this.spawnParticles(world, posNew, false, EnumParticleTypes.VILLAGER_HAPPY);
                }
            }
        }
        return true;
    }

    private boolean spawnPlantRadius(World world, BlockPos pos, Block plantBlock, int metaData) {
        int radius = PlantMegaPack.settings.powderFertilizerRadius / 2;
        int iy = pos.func_177956_o();
        int lowX = pos.func_177958_n() - radius;
        int lowZ = pos.func_177952_p() - radius;
        int highX = pos.func_177958_n() + radius;
        int highZ = pos.func_177952_p() + radius;
        for (int ix = lowX; ix <= highX; ++ix) {
            for (int iz = lowZ; iz <= highZ; ++iz) {
                BlockPos posNew = new BlockPos(ix, iy, iz);
                while (world.func_175623_d(posNew.func_177977_b())) {
                    posNew = new BlockPos(ix, --iy, iz);
                }
                if ((ix != lowX && ix != highX || iz != lowZ && iz != highZ) && world.func_175623_d(posNew)) {
                    IBlockState state;
                    if (plantBlock instanceof BlockBasePlant) {
                        if (((BlockBasePlant)plantBlock).func_176196_c(world, posNew)) {
                            DefPlant defPlant = ((BlockBasePlant)plantBlock).defPlant;
                            state = PlantMegaPack.objects.getPlant(defPlant).func_176223_P();
                            world.func_180501_a(posNew, state, 2);
                            this.spawnParticles(world, posNew, false, EnumParticleTypes.VILLAGER_HAPPY);
                            if (defPlant.getPlantType() == TypePlant.DOUBL) {
                                world.func_180501_a(posNew.func_177984_a(), state.func_177226_a(BlockPlantDouble.HALF, (Comparable)((Object)VariantBlockHalf.TOP)), 2);
                                this.spawnParticles(world, posNew.func_177984_a(), false, EnumParticleTypes.VILLAGER_HAPPY);
                            }
                        }
                    } else if (plantBlock.func_176196_c(world, posNew)) {
                        state = world.func_180495_p(pos);
                        if (plantBlock == Blocks.field_150398_cm) {
                            if (world.func_175623_d(posNew) && world.func_175623_d(posNew.func_177984_a()) && Blocks.field_150398_cm.func_176196_c(world, posNew)) {
                                if (plantBlock == world.func_180495_p(pos.func_177984_a()).func_177230_c()) {
                                    world.func_180501_a(posNew, state, 2);
                                    state = world.func_180495_p(pos.func_177984_a());
                                    world.func_180501_a(posNew.func_177984_a(), state, 2);
                                } else {
                                    state = world.func_180495_p(pos.func_177977_b());
                                    world.func_180501_a(posNew, state, 2);
                                    state = world.func_180495_p(pos);
                                    world.func_180501_a(posNew.func_177984_a(), state, 2);
                                }
                            }
                        } else if (plantBlock instanceof BlockCrops) {
                            state = world.func_180495_p(pos).func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(0));
                            world.func_180501_a(posNew, state, 2);
                        } else {
                            world.func_180501_a(posNew, state, 2);
                        }
                        this.spawnParticles(world, posNew, false, EnumParticleTypes.VILLAGER_HAPPY);
                    }
                }
                iy = pos.func_177956_o();
            }
        }
        return true;
    }
}

