/*
 * Decompiled with CFR 0.152.
 */
package pmp.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.PlantMegaPack;
import pmp.core.def.DefFood;
import pmp.core.def.DefItem;
import pmp.core.def.DefPlant;
import pmp.core.type.TypePlant;
import pmp.core.type.TypePlantCat;
import pmp.core.type.TypePlantRoot;
import pmp.core.type.TypePlantStem;
import pmp.core.variant.VariantColor;
import pmp.item.ItemTooltips;

public class ItemBasePlant
extends ItemBlock {
    protected DefPlant defPlant;

    public ItemBasePlant(DefPlant defPlant, Block block) {
        super(block);
        this.defPlant = defPlant;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        TypePlant typePlant = this.defPlant.plantType;
        if (typePlant.isFloatingPlant() || typePlant.isImmersedPlant()) {
            ItemStack itemstack = player.func_184586_b(hand);
            RayTraceResult raytraceresult = this.func_77621_a(world, player, true);
            if (raytraceresult == null) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
            }
            if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos blockpos = raytraceresult.func_178782_a();
                if (!world.func_175660_a(player, blockpos) || !player.func_175151_a(blockpos.func_177972_a(raytraceresult.field_178784_b), raytraceresult.field_178784_b, itemstack)) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                }
                BlockPos blockpos1 = blockpos.func_177984_a();
                IBlockState iblockstate = world.func_180495_p(blockpos);
                if (iblockstate.func_185904_a() == Material.field_151586_h && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && world.func_175623_d(blockpos1)) {
                    world.func_180501_a(blockpos1, this.field_150939_a.func_176223_P(), 11);
                    this.field_150939_a.func_180633_a(world, blockpos1, this.field_150939_a.func_176223_P(), (EntityLivingBase)player, itemstack);
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    player.func_71029_a(StatList.func_188057_b((Item)this));
                    world.func_184133_a(player, blockpos, SoundEvents.field_187916_gp, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
                }
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        return super.func_77659_a(world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        ItemTooltips.addOreDictName(tooltip, this.defPlant.getOreDictName());
        if (PlantMegaPack.settings.tooltipPlantCategory && this.defPlant.plantCategory != TypePlantCat.HANGP) {
            ItemTooltips.addPlantCategory(tooltip, this.defPlant);
        }
        if (PlantMegaPack.settings.tooltipPlantParts) {
            if (this.defPlant.flowerID >= 0) {
                ItemTooltips.addShearsText(tooltip, String.format("item.flower_%s.name", VariantColor.byIndex((int)this.defPlant.flowerID).itemName));
            }
            if (this.defPlant.stemID >= 0) {
                ItemTooltips.addShearsText(tooltip, TypePlantStem.getStemFromID(this.defPlant.stemID).getUnlocalizedName());
            }
            if (this.defPlant.rootID >= 0) {
                ItemTooltips.addShearsText(tooltip, TypePlantRoot.getRootFromID(this.defPlant.rootID).getUnlocalizedName());
            }
        }
        if (PlantMegaPack.settings.tooltipHints) {
            switch (this.defPlant) {
                case CLIMB_BLUPH: 
                case CLIMB_BRCRE: 
                case CLIMB_JAPCR: 
                case CLIMB_SWPEA_RED: 
                case CLIMB_SWPEA_ORA: 
                case CLIMB_SWPEA_YEL: 
                case CLIMB_SWPEA_GRN: 
                case CLIMB_SWPEA_CYA: 
                case CLIMB_SWPEA_BLU: 
                case CLIMB_SWPEA_PUR: 
                case CLIMB_SWPEA_PNK: 
                case CLIMB_SWPEA_WHT: {
                    ItemTooltips.addCraftingText(tooltip, "gui.hanging_plant");
                    break;
                }
                case FOREW_WOFTC: {
                    ItemTooltips.addCraftingText(tooltip, "item.sulphur.name");
                    break;
                }
                case FUNGU_BLPOW: 
                case FUNGU_CHANT: 
                case FUNGU_GCLUB: 
                case FUNGU_PARAS: 
                case FUNGU_STNKH: 
                case FUNGU_WEMIC: 
                case FUNGU_WOODB: {
                    ItemTooltips.addCraftingText(tooltip, "item.mushroomStew.name");
                    break;
                }
                case GRNDC_TWIG: {
                    ItemTooltips.addCraftingText(tooltip, "item.stick.name");
                    break;
                }
                case SALTW_GKELG: 
                case SALTW_GKELY: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_WRSWD.getLocalizedName());
                    break;
                }
                case VINE_BLSKY: 
                case VINE_JAPIV: 
                case VINE_MADEV: 
                case VINE_SILVC: 
                case VINE_SWEIV: 
                case VINE_VPEIV: 
                case VINE_WISTE_RED: 
                case VINE_WISTE_ORA: 
                case VINE_WISTE_YEL: 
                case VINE_WISTE_GRN: 
                case VINE_WISTE_CYA: 
                case VINE_WISTE_BLU: 
                case VINE_WISTE_PUR: 
                case VINE_WISTE_PNK: 
                case VINE_WISTE_WHT: {
                    ItemTooltips.addCraftingText(tooltip, "gui.hanging_plant");
                    break;
                }
                case VINE_SPAMO: {
                    ItemTooltips.addCraftingText(tooltip, "item.string.name");
                    break;
                }
                case WETLA_CATTA: {
                    ItemTooltips.addCraftingText(tooltip, DefItem.CTAIL_SPIKE.getLocalizedName());
                    break;
                }
            }
            if (this.defPlant.isPoison() && PlantMegaPack.settings.realismPoison) {
                ItemTooltips.addEffectText(tooltip, "gui.poison");
            }
            if (this.defPlant.isThorns() && PlantMegaPack.settings.realismThorns) {
                ItemTooltips.addEffectText(tooltip, "gui.thorns");
            }
        }
    }
}

