/*
 * Decompiled with CFR 0.152.
 */
package pmp.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pmp.PlantMegaPack;
import pmp.core.recipe.RecipePottingTable;
import pmp.inventory.ContainerBase;
import pmp.inventory.slot.SlotPottingTableBonemeal;
import pmp.inventory.slot.SlotPottingTableInput;
import pmp.inventory.slot.SlotPottingTableOutput;
import pmp.inventory.slot.SlotPottingTableSoil;

public class ContainerPottingTable
extends ContainerBase {
    public static final int SLOT_ID_OUTPUT = 0;
    public static final int SLOT_ID_INPUT = 1;
    public static final int SLOT_ID_SOIL = 2;
    public static final int SLOT_ID_BONEMEAL = 3;
    private SlotPottingTableOutput outputSlot;
    private SlotPottingTableInput inputSlot;
    private SlotPottingTableSoil soilSlot;
    private SlotPottingTableBonemeal bonemealSlot;
    private IInventory tileEntityPottingTable;

    public ContainerPottingTable(InventoryPlayer playerInventory, World world, BlockPos pos) {
        super(playerInventory.field_70458_d, world, pos);
        this.tileEntityPottingTable = (IInventory)world.func_175625_s(pos);
    }

    @Override
    protected void initSlots(EntityPlayer player, IInventory playerInventory, World world, BlockPos pos) {
        this.outputSlot = (SlotPottingTableOutput)this.func_75146_a(new SlotPottingTableOutput(this, this.storageInventory, 0, 124, 35));
        this.inputSlot = (SlotPottingTableInput)this.func_75146_a(new SlotPottingTableInput(this, this.storageInventory, 1, 48, 17));
        this.soilSlot = (SlotPottingTableSoil)this.func_75146_a(new SlotPottingTableSoil(this, this.storageInventory, 2, 30, 53));
        this.bonemealSlot = (SlotPottingTableBonemeal)this.func_75146_a(new SlotPottingTableBonemeal(this, this.storageInventory, 3, 66, 53));
        this.createPlayerInventorySlots(playerInventory, 8, 84);
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_175173_a((Container)this, this.tileEntityPottingTable);
    }

    public void func_75142_b() {
        super.func_75142_b();
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return this.tileEntityPottingTable.func_70300_a(player);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index <= 0 || index > 3) {
                if (this.inputSlot.func_75214_a(itemstack1) ? !this.func_75135_a(itemstack1, 1, 2, false) : (SlotPottingTableInput.isValidMaterial(itemstack) && itemstack.func_190916_E() == 1 ? !this.func_75135_a(itemstack1, 0, 1, false) : (SlotPottingTableSoil.isValidMaterial(itemstack) ? !this.func_75135_a(itemstack1, 2, 3, false) : (SlotPottingTableBonemeal.isValidMaterial(itemstack) ? !this.func_75135_a(itemstack1, 3, 4, false) : (index >= 4 && index < 31 ? !this.func_75135_a(itemstack1, 31, 40, false) : (index >= 31 && index < 40 ? !this.func_75135_a(itemstack1, 4, 31, false) : !this.func_75135_a(itemstack1, 4, 40, false))))))) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (!this.func_75135_a(itemstack1, 4, 40, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.updateSlots();
    }

    public void updateSlots() {
        ItemStack stackInput = this.inputSlot.func_75211_c();
        if (!RecipePottingTable.isInputMaterial(stackInput)) {
            this.outputSlot.func_75215_d(ItemStack.field_190927_a);
            return;
        }
        if (!SlotPottingTableSoil.isValidMaterial(this.soilSlot.func_75211_c())) {
            this.outputSlot.func_75215_d(ItemStack.field_190927_a);
            return;
        }
        if (!SlotPottingTableBonemeal.isValidMaterial(this.bonemealSlot.func_75211_c())) {
            this.outputSlot.func_75215_d(ItemStack.field_190927_a);
            return;
        }
        ItemStack stack = RecipePottingTable.getClonedItemStackFromInput(stackInput, PlantMegaPack.settings.pottingTableOutput);
        this.outputSlot.func_75215_d(stack);
    }

    public void onOutputTaken() {
        ItemStack stack = this.inputSlot.func_75211_c();
        stack.func_190918_g(1);
        stack = this.soilSlot.func_75211_c();
        stack.func_190918_g(1);
        stack = this.bonemealSlot.func_75211_c();
        stack.func_190918_g(1);
        this.updateSlots();
    }
}

