/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.screen;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import pmp.PlantMegaPack;
import pmp.gui.GuiButtonLayout;
import pmp.gui.GuiScreenBase;
import pmp.gui.control.GuiPmpButton;
import pmp.gui.control.GuiPmpButtonMode;
import pmp.gui.control.GuiPmpSlider;

public class GuiWorldSettings
extends GuiScreenBase {
    private GuiPmpButton modDimensions;
    private GuiPmpButton useWorldSeed;
    private GuiPmpSlider thresholdSlope;
    private GuiPmpSlider biomeEdgeDetectRadius;
    private GuiPmpSlider tempDetectRadius;
    private GuiPmpSlider thresholdTreeSpawnRadius;

    public GuiWorldSettings(GuiScreen parentGuiScreen) {
        super(parentGuiScreen, null, GuiButtonLayout.DEFAULTS_DONE);
        this.name = String.format("%s %s %s", I18n.func_135052_a((String)"gui.customize", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.world_generation", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xPos = this.getLeftColumnStartX();
        int yPos = this.getButtonRowStartY(2);
        this.useWorldSeed = new GuiPmpButton(this, 10, GuiPmpButtonMode.TOGGLE, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.use_world_seed", (Object[])new Object[0]));
        yPos = this.getButtonRowStartY(3);
        this.modDimensions = new GuiPmpButton(this, 11, GuiPmpButtonMode.TOGGLE, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.modded_dimensions", (Object[])new Object[0]));
        xPos = this.getRightColumnStartX();
        yPos = this.getButtonRowStartY(2);
        this.biomeEdgeDetectRadius = new GuiPmpSlider(this, 20, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.biome_edge_radius", (Object[])new Object[0]), 1, 2, 3, 1);
        yPos = this.getButtonRowStartY(3);
        this.thresholdSlope = new GuiPmpSlider(this, 21, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.slope", (Object[])new Object[0]), 14, 20, 26, 1);
        yPos = this.getButtonRowStartY(4);
        this.tempDetectRadius = new GuiPmpSlider(this, 22, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.temp_detect_radius", (Object[])new Object[0]), 2, 10, 10, 1);
        yPos = this.getButtonRowStartY(5);
        this.thresholdTreeSpawnRadius = new GuiPmpSlider(this, 23, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.tree_spawn_radius", (Object[])new Object[0]), 0, 2, 4, 1);
        this.updateButtonStatesFromSettings();
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 1: {
                    PlantMegaPack.settings.resetWorldgenSettings();
                    this.updateButtonStatesFromSettings();
                    break;
                }
                case 2: {
                    this.updateSettingsFromButtonStates();
                    PlantMegaPack.settings.saveSettings();
                    break;
                }
            }
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int posX = this.getLeftColumnCenterX();
        int posY = this.getButtonRowStartY(1) + 10;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]), posX, posY, 0x60E060);
        posX = this.getRightColumnCenterX();
        posY = this.getButtonRowStartY(1) + 10;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.thresholds", (Object[])new Object[0]), posX, posY, 0x60E060);
    }

    private void updateButtonStatesFromSettings() {
        this.modDimensions.setButtonState(PlantMegaPack.settings.worldgenModDimensions);
        this.useWorldSeed.setButtonState(PlantMegaPack.settings.worldgenUseWorldSeed);
        this.biomeEdgeDetectRadius.setIntValue(PlantMegaPack.settings.worldgenBiomeEdgeDetectRadius);
        this.biomeEdgeDetectRadius.updateDisplayString();
        this.thresholdSlope.setIntValue(PlantMegaPack.settings.worldgenThresholdSlope);
        this.thresholdSlope.updateDisplayString();
        this.tempDetectRadius.setIntValue(PlantMegaPack.settings.worldgenTempDetectRadius);
        this.tempDetectRadius.updateDisplayString();
        this.thresholdTreeSpawnRadius.setIntValue(PlantMegaPack.settings.worldgenThresholdTreeSpawnRadius);
        this.thresholdTreeSpawnRadius.updateDisplayString();
    }

    private void updateSettingsFromButtonStates() {
        PlantMegaPack.settings.worldgenModDimensions = this.modDimensions.getButtonState();
        PlantMegaPack.settings.worldgenBiomeEdgeDetectRadius = this.biomeEdgeDetectRadius.getIntValue();
        PlantMegaPack.settings.worldgenThresholdSlope = this.thresholdSlope.getIntValue();
        PlantMegaPack.settings.worldgenTempDetectRadius = this.tempDetectRadius.getIntValue();
        PlantMegaPack.settings.worldgenThresholdTreeSpawnRadius = this.thresholdTreeSpawnRadius.getIntValue();
        PlantMegaPack.settings.worldgenUseWorldSeed = this.useWorldSeed.getButtonState();
    }
}

