/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.screen;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import pmp.PlantMegaPack;
import pmp.core.data.DataHabitatTree;
import pmp.core.def.DefHabitat;
import pmp.core.type.TypeBiome;
import pmp.gui.GuiButtonLayout;
import pmp.gui.GuiCore;
import pmp.gui.GuiScreenBase;
import pmp.gui.control.GuiPmpSlider;

public class GuiTreeSettings
extends GuiScreenBase {
    private final TypeBiome biome;
    private final DefHabitat habitat;
    private DataHabitatTree dataTree;
    private GuiPmpSlider spawnWeight;

    public GuiTreeSettings(GuiScreen parentGuiScreen, TypeBiome biome, DefHabitat habitat, DataHabitatTree dataTree) {
        super(parentGuiScreen, null, GuiButtonLayout.DEFAULTS_DONE);
        this.biome = biome;
        this.habitat = habitat;
        this.dataTree = dataTree;
        this.name = String.format("%s %s %s", I18n.func_135052_a((String)"gui.customize", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.tree", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xPos = this.getCenteredButtonStartX(180);
        int yPos = this.getButtonRowStartY(3);
        this.spawnWeight = new GuiPmpSlider(this, 10, xPos, yPos, 180, 20, I18n.func_135052_a((String)"gui.spawn_weight", (Object[])new Object[0]), 1, 50, 100, 1);
        this.updateButtonStatesFromSettings();
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 1: {
                    this.dataTree.applyDefaultSettings();
                    this.updateButtonStatesFromSettings();
                    break;
                }
                case 2: {
                    this.updateSettingsFromButtonStates();
                    PlantMegaPack.settings.saveBiomeSettings(this.biome);
                    break;
                }
            }
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int posX = this.field_146294_l / 2 - 16;
        int posY = this.getButtonRowStartY(1);
        if (this.dataTree != null) {
            GuiCore.drawTreeTexture(this.dataTree.getDefTree(), posX, posY, 32);
        }
    }

    private void updateButtonStatesFromSettings() {
        this.spawnWeight.setIntValue(this.dataTree.spawnWeight);
        this.spawnWeight.updateDisplayString();
    }

    private void updateSettingsFromButtonStates() {
        this.dataTree.spawnWeight = this.spawnWeight.getIntValue();
    }
}

