/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.screen;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import pmp.PlantMegaPack;
import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitatPlant;
import pmp.core.def.DefHabitat;
import pmp.core.def.DefPlant;
import pmp.core.type.TypeBiome;
import pmp.gui.GuiButtonLayout;
import pmp.gui.GuiCore;
import pmp.gui.GuiScreenBase;
import pmp.gui.control.GuiPmpListbox;
import pmp.gui.control.GuiPmpListboxState;
import pmp.gui.control.IListboxOwner;

public class GuiPlantAddToHabitat
extends GuiScreenBase
implements IListboxOwner {
    private final TypeBiome biome;
    private final DefHabitat habitat;
    private DefPlant plantSelected = null;
    private GuiPmpListbox plantList;
    private static GuiPmpListboxState listboxState = new GuiPmpListboxState();

    public GuiPlantAddToHabitat(GuiScreen parentGuiScreen, TypeBiome biome, DefHabitat habitat) {
        super(parentGuiScreen, null, GuiButtonLayout.CANCEL_DONE);
        this.biome = biome;
        this.habitat = habitat;
        this.name = String.format("%s %s - %s %s", this.biome.getLocalizedName(), this.habitat.getLocalizedName(), I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.plant", (Object[])new Object[0]));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xPos = this.getCenteredButtonStartX(150);
        int yPos = this.getButtonRowStartY(1);
        this.plantList = new GuiPmpListbox(this, xPos, yPos, this.getListboxWidth(), this.getListboxHeight(), this.getFontRenderer().field_78288_b + 2);
        this.populatePlantList();
        this.plantList.setListboxState(listboxState);
        this.listItemSelected(this.plantList, GuiPlantAddToHabitat.listboxState.selectedElement);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.plantList.func_178039_p();
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 2: {
                    listboxState.resetState();
                    DataBiome dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.biome);
                    if (dataBiome != null) {
                        DefPlant newPlant = DefPlant.getPlantFromName(this.plantList.getSelectedItemKey());
                        dataBiome.habitats.get((Object)this.habitat).getPlants().put(newPlant, new DataHabitatPlant(this.habitat, newPlant));
                    }
                    PlantMegaPack.settings.saveBiomeSettings(this.biome);
                    break;
                }
            }
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.plantList.func_148128_a(mouseX, mouseY, partialTicks);
        if (this.plantSelected != null) {
            int xPos = this.getCenteredButtonStartX(150) + this.getListboxWidth() + 2;
            int yPos = this.getButtonRowStartY(1);
            GuiCore.drawPlantTexture(this.plantSelected, xPos, yPos, 32);
        }
    }

    @Override
    public void listItemSelected(GuiPmpListbox list, int index) {
        this.plantSelected = DefPlant.getPlantFromName(this.plantList.getSelectedItemKey());
    }

    @Override
    public void listItemDoubleClicked(GuiPmpListbox list, int slotIndex) {
        this.func_146284_a(this.buttonDone);
    }

    private void populatePlantList() {
        DataBiome dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.biome);
        for (DefPlant defPlant : DefPlant.values()) {
            if (!defPlant.canConfig() || !defPlant.canPlantSpawnInHabitat(this.habitat) || dataBiome.habitats.get((Object)this.habitat).getPlants().containsKey(defPlant)) continue;
            this.plantList.addListboxEntry(defPlant.getBlockName(), defPlant.getLocalizedName());
        }
    }
}

