/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.screen;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import pmp.PlantMegaPack;
import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.DataHabitatTree;
import pmp.core.def.DefHabitat;
import pmp.core.def.DefTree;
import pmp.core.type.TypeBiome;
import pmp.gui.GuiButtonLayout;
import pmp.gui.GuiCore;
import pmp.gui.GuiScreenBase;
import pmp.gui.control.GuiPmpButton;
import pmp.gui.control.GuiPmpButtonMode;
import pmp.gui.control.GuiPmpListbox;
import pmp.gui.control.GuiPmpListboxState;
import pmp.gui.control.IListboxOwner;
import pmp.gui.screen.GuiTreeAddToHabitat;
import pmp.gui.screen.GuiTreeSettings;

public class GuiHabitatTrees
extends GuiScreenBase
implements IListboxOwner {
    private final TypeBiome typeBiome;
    private final DefHabitat defHabitat;
    private DefTree treeSelected;
    private GuiPmpListbox treeList;
    private static GuiPmpListboxState listboxState = new GuiPmpListboxState();
    private GuiPmpButton buttonSettings;
    private GuiPmpButton buttonAdd;
    private GuiPmpButton buttonRemove;

    public GuiHabitatTrees(GuiScreen parentGuiScreen, TypeBiome biome, DefHabitat habitat) {
        super(parentGuiScreen, null, GuiButtonLayout.DEFAULTS_DONE);
        this.typeBiome = biome;
        this.defHabitat = habitat;
        this.name = String.format("%s %s %s %s", I18n.func_135052_a((String)"gui.customize", (Object[])new Object[0]), this.typeBiome.getLocalizedName(), this.defHabitat.getLocalizedName(), I18n.func_135052_a((String)"gui.trees", (Object[])new Object[0]));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xPos = this.getListboxStartX();
        int yPos = this.getButtonRowStartY(2);
        this.treeList = new GuiPmpListbox(this, xPos, yPos, this.getListboxWidth(), this.getListboxHeight(), this.getFontRenderer().field_78288_b + 2);
        xPos = this.field_146294_l / 2 + 4;
        yPos = this.getButtonRowStartY(5);
        this.buttonSettings = new GuiPmpButton(this, 10, GuiPmpButtonMode.NORMAL, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]) + "...");
        yPos = this.getButtonRowStartY(6);
        this.buttonAdd = new GuiPmpButton(this, 11, GuiPmpButtonMode.NORMAL, xPos, yPos, 73, 20, I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]) + "...");
        xPos = this.field_146294_l / 2 + 8 + 73;
        this.buttonRemove = new GuiPmpButton(this, 12, GuiPmpButtonMode.NORMAL, xPos, yPos, 73, 20, I18n.func_135052_a((String)"gui.remove", (Object[])new Object[0]));
        this.populateTreeList();
        this.treeList.setListboxState(listboxState);
        this.listItemSelected(this.treeList, GuiHabitatTrees.listboxState.selectedElement);
        this.updateControls();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.treeList.func_178039_p();
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        DataBiome dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.typeBiome);
        DataHabitat dataHabitat = null;
        DataHabitatTree dataTree = null;
        if (dataBiome != null && (dataHabitat = dataBiome.habitats.get((Object)this.defHabitat)) != null && this.treeList.func_148127_b() > 0) {
            dataTree = dataHabitat.getHabitatTreeData(DefTree.getTreeFromName(this.treeList.getSelectedItemKey()));
        }
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 1: {
                    listboxState.resetState();
                    if (dataBiome != null) {
                        dataBiome.applyDefaultHabitatTrees(this.defHabitat, true);
                    }
                    this.treeList.clearAllEntries();
                    this.populateTreeList();
                    this.listItemSelected(this.treeList, GuiHabitatTrees.listboxState.selectedElement);
                    this.updateControls();
                    break;
                }
                case 2: {
                    listboxState.resetState();
                    PlantMegaPack.settings.saveBiomeSettings(this.typeBiome);
                    break;
                }
                case 10: {
                    if (dataTree != null) {
                        this.treeList.saveListboxState(listboxState);
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiTreeSettings(this, this.typeBiome, this.defHabitat, dataTree));
                    }
                    return;
                }
                case 11: {
                    this.treeList.saveListboxState(listboxState);
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiTreeAddToHabitat((GuiScreen)this, this.typeBiome, this.defHabitat));
                    return;
                }
                case 12: {
                    dataHabitat.removeTree(DefTree.getTreeFromName(this.treeList.getSelectedItemKey()));
                    this.treeList.clearAllEntries();
                    this.populateTreeList();
                    listboxState.resetState();
                    this.listItemSelected(this.treeList, GuiHabitatTrees.listboxState.selectedElement);
                    this.updateControls();
                    return;
                }
            }
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.treeList.func_148128_a(mouseX, mouseY, partialTicks);
        int posX = this.getLeftColumnCenterX();
        int posY = this.getButtonRowStartY(1) + 10;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.trees", (Object[])new Object[0]), posX, posY, 0x60E060);
        posX = this.getRightColumnCenterX();
        posY = this.getButtonRowStartY(4) + 10;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.actions", (Object[])new Object[0]), posX, posY, 0x60E060);
        posX = this.getRightColumnCenterX() - 16;
        posY = this.getButtonRowStartY(1);
        if (this.treeSelected != null) {
            DataHabitatTree dataTree;
            DataHabitat dataHabitat;
            GuiCore.drawTreeTexture(this.treeSelected, posX, posY, 32);
            DataBiome dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.typeBiome);
            if (dataBiome != null && (dataHabitat = dataBiome.habitats.get((Object)this.defHabitat)) != null && (dataTree = dataHabitat.getHabitatTreeData(this.treeSelected)) != null) {
                posX = this.getRightColumnStartX() + 14;
                posY = this.getButtonRowStartY(3);
                GuiCore.drawLEDBar(posX, posY, 20, dataTree.spawnWeight * 20 / 100);
            }
        }
    }

    @Override
    public void listItemSelected(GuiPmpListbox list, int slotIndex) {
        this.treeSelected = DefTree.getTreeFromName(this.treeList.getSelectedItemKey());
        this.treeList.saveListboxState(listboxState);
        this.updateControls();
    }

    @Override
    public void listItemDoubleClicked(GuiPmpListbox list, int slotIndex) {
        if (this.treeList.func_148127_b() > 0) {
            this.func_146284_a(this.buttonSettings);
        }
    }

    private void updateControls() {
        boolean listPopulated;
        this.buttonSettings.field_146124_l = listPopulated = this.treeList.func_148127_b() > 0;
        this.buttonRemove.field_146124_l = listPopulated;
    }

    private void populateTreeList() {
        DataHabitat dataHabitat;
        DataBiome dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.typeBiome);
        if (dataBiome != null && (dataHabitat = dataBiome.habitats.get((Object)this.defHabitat)) != null) {
            dataHabitat.getTrees().forEach((k, v) -> this.treeList.addListboxEntry(k.blockName, k.getLocalizedTreeName()));
        }
    }
}

