/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.screen;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import pmp.PlantMegaPack;
import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.def.DefHabitat;
import pmp.core.type.TypeBiome;
import pmp.gui.GuiButtonLayout;
import pmp.gui.GuiScreenBase;
import pmp.gui.control.GuiPmpSlider;
import pmp.gui.control.GuiPmpSliderMode;

public class GuiHabitatSettings
extends GuiScreenBase {
    private final TypeBiome biome;
    private final DefHabitat habitat;
    private GuiPmpSlider worldgenRatePlants;
    private GuiPmpSlider worldgenRateTrees;

    public GuiHabitatSettings(GuiScreen parentGuiScreen, TypeBiome biome, DefHabitat habitat) {
        super(parentGuiScreen, null, GuiButtonLayout.DEFAULTS_DONE);
        this.biome = biome;
        this.habitat = habitat;
        this.name = String.format("%s %s %s %s", I18n.func_135052_a((String)"gui.customize", (Object[])new Object[0]), this.biome.getLocalizedName(), this.habitat.getLocalizedName(), I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int yPos = this.getButtonRowStartY(2);
        if (this.habitat.canHabitatContainTrees()) {
            int xPos = this.getLeftColumnStartX();
            yPos = this.getButtonRowStartY(2);
            this.worldgenRatePlants = new GuiPmpSlider(this, 10, xPos, yPos, 150, 20, String.format("%s %s", I18n.func_135052_a((String)"gui.gen_rate", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.plants", (Object[])new Object[0])), 0, 50, 100, 1);
            this.worldgenRatePlants.setSliderMode(GuiPmpSliderMode.PERCENT);
            xPos = this.getRightColumnStartX();
            yPos = this.getButtonRowStartY(2);
            this.worldgenRateTrees = new GuiPmpSlider(this, 20, xPos, yPos, 150, 20, String.format("%s %s", I18n.func_135052_a((String)"gui.gen_rate", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.trees", (Object[])new Object[0])), 0, 50, 100, 1);
            this.worldgenRateTrees.setSliderMode(GuiPmpSliderMode.PERCENT);
        } else {
            int xPos = this.getCenteredButtonStartX(150);
            this.worldgenRatePlants = new GuiPmpSlider(this, 10, xPos, yPos, 150, 20, String.format("%s %s", I18n.func_135052_a((String)"gui.gen_rate", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.plants", (Object[])new Object[0])), 0, 50, 100, 1);
            this.worldgenRatePlants.setSliderMode(GuiPmpSliderMode.PERCENT);
        }
        this.updateButtonStatesFromSettings();
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 1: {
                    DataBiome dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.biome);
                    if (dataBiome != null) {
                        dataBiome.applyDefaultHabitatSettings(this.habitat);
                    }
                    this.updateButtonStatesFromSettings();
                    break;
                }
                case 2: {
                    this.updateSettingsFromButtonStates();
                    PlantMegaPack.settings.saveBiomeSettings(this.biome);
                    break;
                }
            }
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int posX = this.getLeftColumnCenterX();
        int posY = this.getButtonRowStartY(1) + 10;
        if (this.habitat.canHabitatContainTrees()) {
            posX = this.getLeftColumnCenterX();
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.plants", (Object[])new Object[0]), posX, posY, 0x60E060);
            posX = this.getRightColumnCenterX();
            posY = this.getButtonRowStartY(1) + 10;
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.trees", (Object[])new Object[0]), posX, posY, 0x60E060);
        } else {
            posX = this.field_146294_l / 2;
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.plants", (Object[])new Object[0]), posX, posY, 0x60E060);
        }
    }

    private void updateButtonStatesFromSettings() {
        DataHabitat dataHabitat;
        DataBiome dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.biome);
        if (dataBiome != null && (dataHabitat = dataBiome.habitats.get((Object)this.habitat)) != null) {
            this.worldgenRatePlants.setIntValue(dataHabitat.worldgenRatePlants);
            this.worldgenRatePlants.updateDisplayString();
            if (this.habitat.canHabitatContainTrees()) {
                this.worldgenRateTrees.setIntValue(dataHabitat.worldgenRateTrees);
                this.worldgenRateTrees.updateDisplayString();
            }
        }
    }

    private void updateSettingsFromButtonStates() {
        DataHabitat dataHabitat;
        DataBiome dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.biome);
        if (dataBiome != null && (dataHabitat = dataBiome.habitats.get((Object)this.habitat)) != null) {
            dataHabitat.worldgenRatePlants = this.worldgenRatePlants.getIntValue();
            if (this.habitat.canHabitatContainTrees()) {
                dataHabitat.worldgenRateTrees = this.worldgenRateTrees.getIntValue();
            }
        }
    }
}

