/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.screen;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import pmp.PlantMegaPack;
import pmp.core.def.DefWorkbench;
import pmp.gui.GuiButtonLayout;
import pmp.gui.GuiCore;
import pmp.gui.GuiScreenBase;
import pmp.gui.control.GuiPmpButton;
import pmp.gui.control.GuiPmpButtonMode;
import pmp.gui.control.GuiPmpListbox;
import pmp.gui.control.GuiPmpSlider;
import pmp.gui.control.IListboxOwner;

public class GuiGeneralWorkbench
extends GuiScreenBase
implements IListboxOwner {
    private GuiPmpListbox blockList;
    private DefWorkbench workbenchSelected = null;
    private GuiPmpSlider sliderOperateTime;
    private GuiPmpButton buttonDefault;

    public GuiGeneralWorkbench(GuiScreen parentGuiScreen) {
        super(parentGuiScreen, "gui.workbenches", GuiButtonLayout.DONE);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xPos = this.getListboxStartX();
        int yPos = this.getButtonRowStartY(1);
        this.blockList = new GuiPmpListbox(this, xPos, yPos, this.getListboxWidth(), this.getListboxHeight(), this.getFontRenderer().field_78288_b + 2);
        xPos = this.field_146294_l / 2 + 4;
        yPos = this.getButtonRowStartY(3);
        this.sliderOperateTime = new GuiPmpSlider(this, 10, xPos, yPos, 150, 20, "gui.operating_time", 25, 25, 250, 1);
        yPos = this.getButtonRowStartY(5);
        this.buttonDefault = new GuiPmpButton(this, 12, GuiPmpButtonMode.NORMAL, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.default", (Object[])new Object[0]));
        this.populateBlockList();
        this.blockList.selectListItem(0);
        this.listItemSelected(this.blockList, 0);
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 2: {
                    this.updateSettingsFromButtonStates();
                    PlantMegaPack.settings.saveSettings();
                    break;
                }
                case 12: {
                    this.applyDefaultSettings();
                    PlantMegaPack.settings.saveSettings();
                    break;
                }
            }
        }
        super.func_146284_a(button);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.blockList.func_178039_p();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.blockList.func_148128_a(mouseX, mouseY, partialTicks);
        if (this.workbenchSelected != null) {
            GuiCore.drawBlockTexture(this.workbenchSelected.getBlockName() + "_fr", this.field_146294_l / 2 + 4, 36, 32);
        }
    }

    @Override
    public void listItemSelected(GuiPmpListbox list, int slotIndex) {
        DefWorkbench workbench = DefWorkbench.getWorkbenchFromName(list.getSelectedItemKey());
        if (this.workbenchSelected != workbench) {
            this.updateSettingsFromButtonStates();
            this.workbenchSelected = workbench;
            this.updateButtonStatesFromSettings();
        }
    }

    @Override
    public void listItemDoubleClicked(GuiPmpListbox list, int slotIndex) {
    }

    @Override
    public void onSliderUpdate(GuiPmpSlider slider, int value) {
    }

    private void populateBlockList() {
        for (DefWorkbench defWorkbench : DefWorkbench.values()) {
            this.blockList.addListboxEntry(defWorkbench.getBlockName(), defWorkbench.getLocalizedName());
        }
    }

    private void applyDefaultSettings() {
        if (this.workbenchSelected == null) {
            return;
        }
        switch (this.workbenchSelected) {
            default: 
        }
        this.updateButtonStatesFromSettings();
    }

    private void updateButtonStatesFromSettings() {
        this.sliderOperateTime.setMinMax(25.0f, 250.0f);
        this.sliderOperateTime.setName("gui.operating_time");
        switch (this.workbenchSelected) {
            case POTTING_TABLE: {
                this.sliderOperateTime.setMinMax(4.0f, 32.0f);
                this.sliderOperateTime.setName("gui.clones_produced");
                this.sliderOperateTime.setIntValue(PlantMegaPack.settings.pottingTableOutput);
                break;
            }
            default: {
                return;
            }
        }
        this.sliderOperateTime.updateDisplayString();
    }

    private void updateSettingsFromButtonStates() {
        if (this.workbenchSelected == null) {
            return;
        }
        switch (this.workbenchSelected) {
            case POTTING_TABLE: {
                PlantMegaPack.settings.pottingTableOutput = this.sliderOperateTime.getIntValue();
                break;
            }
            default: {
                return;
            }
        }
    }
}

