/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.control;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import pmp.gui.GuiScreenBase;
import pmp.gui.control.GuiPmpButton;
import pmp.gui.control.GuiPmpButtonMode;
import pmp.gui.control.GuiPmpSliderMode;

@SideOnly(value=Side.CLIENT)
public class GuiPmpSlider
extends GuiPmpButton {
    GuiScreenBase parent;
    private String name;
    private String labelPrefix;
    private String labelSuffix;
    private float sliderValue;
    public boolean mouseButtonDown;
    private float valueMin;
    private float valueMax;
    private float valueStep;
    private GuiPmpSliderMode sliderMode;
    private boolean notifyParentOnChange;

    public GuiPmpSlider(GuiScreenBase parent, int id, int xPosition, int yPosition, int width, int height, String name, int valueMin, int valueInitial, int valueMax, int valueStep) {
        super(parent, id, GuiPmpButtonMode.NORMAL, xPosition, yPosition, width, height, name);
        this.parent = parent;
        this.name = name;
        this.labelPrefix = "";
        this.labelSuffix = "";
        this.sliderMode = GuiPmpSliderMode.NORMAL;
        this.valueStep = valueStep;
        this.valueMin = valueMin;
        this.valueMax = valueMax;
        this.sliderValue = this.normalizeValue(valueInitial);
        this.notifyParentOnChange = false;
        this.updateDisplayString();
    }

    public int func_146114_a(boolean state) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int xPos, int yPos) {
        if (this.field_146125_m) {
            if (this.mouseButtonDown) {
                this.sliderValue = (float)(xPos - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                if (this.sliderValue < 0.0f) {
                    this.sliderValue = 0.0f;
                }
                if (this.sliderValue > 1.0f) {
                    this.sliderValue = 1.0f;
                }
                this.sliderValue = this.normalizeValue(this.getIntValue());
                this.updateDisplayString();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
            if (this.notifyParentOnChange) {
                this.parent.onSliderUpdate(this, this.getIntValue());
            }
        }
    }

    @Override
    public boolean func_146116_c(Minecraft mc, int xPos, int yPos) {
        if (super.func_146116_c(mc, xPos, yPos)) {
            this.sliderValue = (float)(xPos - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            this.updateDisplayString();
            this.mouseButtonDown = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int xPos, int yPos) {
        this.mouseButtonDown = false;
    }

    private float normalizeValue(float value) {
        return MathHelper.func_76131_a((float)((this.snapToStepClamp(value) - this.valueMin) / (this.valueMax - this.valueMin)), (float)0.0f, (float)1.0f);
    }

    private float denormalizeValue(float value) {
        return this.snapToStepClamp(this.valueMin + (this.valueMax - this.valueMin) * MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f));
    }

    private float snapToStepClamp(float value) {
        value = this.snapToStep(value);
        return MathHelper.func_76131_a((float)value, (float)this.valueMin, (float)this.valueMax);
    }

    private float snapToStep(float value) {
        if (this.valueStep > 0.0f) {
            value = this.valueStep * (float)Math.round(value / this.valueStep);
        }
        return value;
    }

    public int getIntValue() {
        return (int)this.denormalizeValue(this.sliderValue);
    }

    public void setIntValue(int value) {
        if ((float)value < this.valueMin || (float)value > this.valueMax) {
            return;
        }
        this.sliderValue = this.normalizeValue(value);
    }

    public float getFloatValue() {
        return this.denormalizeValue(this.sliderValue);
    }

    public void setFloatValue(float value) {
        if (value < this.valueMin || value > this.valueMax) {
            return;
        }
        this.sliderValue = this.normalizeValue(value);
    }

    public void setLabelPrefix(String prefix) {
        this.labelPrefix = prefix;
    }

    public void setLabelSuffix(String suffix) {
        this.labelSuffix = suffix;
    }

    public void setSliderMode(GuiPmpSliderMode mode) {
        if (mode == null) {
            return;
        }
        this.sliderMode = mode;
    }

    public void setNotifyParentOnUpdate(boolean notify) {
        this.notifyParentOnChange = notify;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMinMax(float valueMin, float valueMax) {
        this.valueMin = valueMin;
        this.valueMax = valueMax;
    }

    public void updateDisplayString() {
        String string = this.field_146126_j = this.labelPrefix.isEmpty() ? "" : this.labelPrefix;
        if (this.sliderMode == GuiPmpSliderMode.DENSITY) {
            this.field_146126_j = this.field_146126_j + I18n.func_135052_a((String)this.name, (Object[])new Object[0]) + ": ";
            switch (this.getIntValue()) {
                case 0: {
                    this.field_146126_j = this.field_146126_j + I18n.func_135052_a((String)"gui.low", (Object[])new Object[0]);
                    break;
                }
                case 1: {
                    this.field_146126_j = this.field_146126_j + I18n.func_135052_a((String)"gui.medium", (Object[])new Object[0]);
                    break;
                }
                case 2: {
                    this.field_146126_j = this.field_146126_j + I18n.func_135052_a((String)"gui.high", (Object[])new Object[0]);
                    break;
                }
            }
        } else if (this.sliderMode == GuiPmpSliderMode.NORMAL) {
            this.field_146126_j = this.field_146126_j + I18n.func_135052_a((String)this.name, (Object[])new Object[0]) + ": ";
            this.field_146126_j = this.field_146126_j + (this.valueStep > 0.0f ? (this.getIntValue() > 0 ? String.valueOf(this.getIntValue()) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0])) : String.valueOf(this.getIntValue()));
            if (!this.labelSuffix.isEmpty()) {
                this.field_146126_j = this.field_146126_j + this.labelSuffix;
            }
        } else if (this.sliderMode == GuiPmpSliderMode.PERCENT) {
            this.field_146126_j = this.field_146126_j + I18n.func_135052_a((String)this.name, (Object[])new Object[0]) + ": ";
            this.field_146126_j = this.field_146126_j + (this.valueStep > 0.0f ? (this.getIntValue() > 0 ? String.valueOf(this.getIntValue()) + "%" : I18n.func_135052_a((String)"options.off", (Object[])new Object[0])) : String.valueOf(this.getIntValue()));
        }
    }
}

