/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;

@SideOnly(value=Side.CLIENT)
public abstract class GuiCore {
    public static final ResourceLocation MOD_LOGO = new ResourceLocation("pmp:textures/gui/logo.png");
    public static final ResourceLocation LED_OFF = new ResourceLocation("pmp:textures/gui/led_0.png");
    public static final ResourceLocation LED_ON = new ResourceLocation("pmp:textures/gui/led_1.png");
    public static final ResourceLocation MINI_LED_0 = new ResourceLocation("pmp:textures/gui/mini_led_0.png");
    public static final ResourceLocation MINI_LED_1 = new ResourceLocation("pmp:textures/gui/mini_led_1.png");
    public static final ResourceLocation MINI_LED_2 = new ResourceLocation("pmp:textures/gui/mini_led_2.png");
    public static final ResourceLocation MINI_LED_3 = new ResourceLocation("pmp:textures/gui/mini_led_3.png");
    public static final ResourceLocation MINI_LED_4 = new ResourceLocation("pmp:textures/gui/mini_led_4.png");
    public static final ResourceLocation MINI_LED_5 = new ResourceLocation("pmp:textures/gui/mini_led_5.png");
    public static final ResourceLocation MINI_LED_6 = new ResourceLocation("pmp:textures/gui/mini_led_6.png");
    public static final ResourceLocation MINI_LED_7 = new ResourceLocation("pmp:textures/gui/mini_led_7.png");
    public static final ResourceLocation MINI_LED_8 = new ResourceLocation("pmp:textures/gui/mini_led_8.png");
    public static final ResourceLocation MINI_LED_9 = new ResourceLocation("pmp:textures/gui/mini_led_9.png");
    public static final ResourceLocation MINI_LED_A = new ResourceLocation("pmp:textures/gui/mini_led_a.png");
    public static final ResourceLocation MINI_LED_B = new ResourceLocation("pmp:textures/gui/mini_led_b.png");
    public static final ResourceLocation MINI_LED_C = new ResourceLocation("pmp:textures/gui/mini_led_c.png");
    public static final ResourceLocation MINI_LED_D = new ResourceLocation("pmp:textures/gui/mini_led_d.png");
    public static final ResourceLocation MINI_LED_E = new ResourceLocation("pmp:textures/gui/mini_led_e.png");
    public static final ResourceLocation MINI_LED_F = new ResourceLocation("pmp:textures/gui/mini_led_f.png");
    public static final int BORDER = 6;
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTON_SPACING = 4;
    public static final int BUTTON_WIDTH_LARGE = 180;
    public static final int BUTTON_WIDTH_MED = 150;
    public static final int BUTTON_WIDTH_SMALL = 73;
    public static final int LED_HEIGHT = 20;
    public static final int LED_SPACING = 0;
    public static final int LED_WIDTH = 6;
    public static final int LED_MINI_HEIGHT = 3;
    public static final int LED_MINI_WIDTH = 4;
    public static final int LOGO_HEIGHT = 16;
    public static final int LOGO_WIDTH = 128;
    public static final int MIN_ICON_DRAW_SIZE = 16;
    public static final int START_Y = 36;
    public static final int TEXT_COLOR_GRAY = 0x404040;
    public static final int TEXT_COLOR_BACKGROUND = 7686922;
    public static final int TEXT_COLOR_DISABLED = 0x208020;
    public static final int TEXT_COLOR_NORMAL = 0x60E060;
    public static final int TEXT_COLOR_MOUSEOVER = 0xFFFF80;
    public static final int TEXT_COLOR_SELECTED = 0xA0FFA0;
    public static final int TEXT_COLOR_YELLOW = 0xFFFF80;

    public static void drawTexture(ResourceLocation texture, int x, int y, int width, int height) {
        if (texture == null) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float zLevel = 1.0f;
        GlStateManager.func_179147_l();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
    }

    public static void drawLED(int x, int y, boolean enabled, boolean indicatorOn) {
        ResourceLocation texture = enabled & indicatorOn ? LED_ON : LED_OFF;
        GuiCore.drawTexture(texture, x, y, 6, 20);
    }

    public static void drawLEDBar(int x, int y, int elements, int lightedElements) {
        if (elements < 1 || elements > 20 || lightedElements < 0 || lightedElements > elements) {
            return;
        }
        for (int index = 1; index <= elements; ++index) {
            GuiCore.drawLED(x + 6 * (index - 1), y, index <= lightedElements, true);
        }
    }

    public static void drawMiniLED(int x, int y, char color) {
        ResourceLocation texture;
        switch (color) {
            case '0': {
                texture = MINI_LED_0;
                break;
            }
            case '1': {
                texture = MINI_LED_1;
                break;
            }
            case '2': {
                texture = MINI_LED_2;
                break;
            }
            case '3': {
                texture = MINI_LED_3;
                break;
            }
            case '4': {
                texture = MINI_LED_4;
                break;
            }
            case '5': {
                texture = MINI_LED_5;
                break;
            }
            case '6': {
                texture = MINI_LED_6;
                break;
            }
            case '7': {
                texture = MINI_LED_7;
                break;
            }
            case '8': {
                texture = MINI_LED_8;
                break;
            }
            case '9': {
                texture = MINI_LED_9;
                break;
            }
            case 'a': {
                texture = MINI_LED_A;
                break;
            }
            case 'b': {
                texture = MINI_LED_B;
                break;
            }
            case 'c': {
                texture = MINI_LED_C;
                break;
            }
            case 'd': {
                texture = MINI_LED_D;
                break;
            }
            case 'e': {
                texture = MINI_LED_E;
                break;
            }
            case 'f': {
                texture = MINI_LED_F;
                break;
            }
            default: {
                texture = MINI_LED_0;
            }
        }
        GuiCore.drawTexture(texture, x, y, 4, 3);
    }

    public static void drawMiniLEDBar(int x, int y, int maxElements, int elements, char color) {
        for (int index = 1; index <= maxElements; ++index) {
            if (index <= elements) {
                GuiCore.drawMiniLED(x, y - 3 * (index - 1) + index, color);
                continue;
            }
            GuiCore.drawMiniLED(x, y - 3 * (index - 1) + index, '0');
        }
    }

    public static void drawPlantTexture(DefPlant plant, int xPos, int yPos, int size) {
        String blockName = plant.getBlockName();
        switch (plant.plantType) {
            case BAMB: {
                blockName = blockName + "_4";
                break;
            }
            case CROPA: {
                blockName = blockName + "_7_t";
                break;
            }
            case CROPF: 
            case CROPS: 
            case BBUSH: {
                blockName = blockName + "_7";
                break;
            }
            case CROPD: {
                blockName = blockName + "_3";
                break;
            }
            case CLIMB: {
                blockName = blockName + "_3";
                break;
            }
            case DOUBL: {
                blockName = blockName + "_t";
                break;
            }
            case EPIFL: 
            case EPIFU: {
                blockName = blockName + "_0";
                break;
            }
            case FLOAT: {
                blockName = blockName + "_b";
                break;
            }
            case FLFLW: {
                blockName = blockName + "_t";
                break;
            }
            case IMMER: 
            case IMMED: {
                blockName = blockName + "_t";
                break;
            }
            case VINE: {
                blockName = blockName + "_b";
                break;
            }
        }
        ResourceLocation itemTextureFile = new ResourceLocation(String.format("%s:textures/blocks/%s.png", "pmp", blockName));
        if (itemTextureFile != null) {
            GuiCore.drawTexture(itemTextureFile, xPos, yPos, size, size);
        }
    }

    public static void drawTreeTexture(DefTree tree, int xPos, int yPos, int size) {
        ResourceLocation itemTextureFile = new ResourceLocation(String.format("%s:textures/blocks/sapli_%s.png", "pmp", tree.blockName));
        if (itemTextureFile != null) {
            GuiCore.drawTexture(itemTextureFile, xPos, yPos, size, size);
        }
    }

    public static void drawBlockTexture(String textureName, int xPos, int yPos, int size) {
        ResourceLocation itemTextureFile;
        if ((textureName == null || !textureName.isEmpty() && size >= 16) && (itemTextureFile = new ResourceLocation(String.format("%s:textures/blocks/%s.png", "pmp", textureName))) != null) {
            GuiCore.drawTexture(itemTextureFile, xPos, yPos, size, size);
        }
    }

    public static void drawItemTexture(String unlocalizedName, int xPos, int yPos, int size) {
        if (unlocalizedName == null || unlocalizedName.isEmpty()) {
            return;
        }
        ResourceLocation itemTextureFile = new ResourceLocation("pmp:textures/items/" + unlocalizedName + ".png");
        GuiCore.drawTexture(itemTextureFile, xPos, yPos, size, size);
    }
}

