/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.type;

import net.minecraft.client.resources.I18n;
import pmp.core.def.DefItem;

public enum TypePlantStem {
    HARD(0, "hard", '6', DefItem.STEM_HARD),
    SOFT(1, "soft", 'a', DefItem.STEM_SOFT),
    CACTUS(2, "cactu", '2', DefItem.STEM_CACTU);

    private static final TypePlantStem[] ID_LOOKUP;
    public final int ID;
    public final String itemName;
    public final char formatCode;
    public final DefItem stemItem;

    private TypePlantStem(int ID, String itemName, char formatCode, DefItem stemItem) {
        this.ID = ID;
        this.itemName = itemName;
        this.formatCode = formatCode;
        this.stemItem = stemItem;
    }

    public String getUnlocalizedName() {
        return String.format("item.stem_%s.name", this.itemName);
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public String getLocalizedNameFormatted() {
        return String.format("\u00a7%s", Character.valueOf(this.formatCode)) + this.getLocalizedName() + "\u00a7r";
    }

    public static DefItem getStemItemFromID(int ID) {
        return TypePlantStem.getStemFromID((int)ID).stemItem;
    }

    public static TypePlantStem getStemFromID(int ID) {
        if (ID < 0 || ID >= ID_LOOKUP.length) {
            ID = 0;
        }
        return ID_LOOKUP[ID];
    }

    static {
        ID_LOOKUP = new TypePlantStem[TypePlantStem.values().length];
        TypePlantStem[] typePlantStemArray = TypePlantStem.values();
        int n = typePlantStemArray.length;
        for (int i = 0; i < n; ++i) {
            TypePlantStem variant$enumtype;
            TypePlantStem.ID_LOOKUP[variant$enumtype.ID] = variant$enumtype = typePlantStemArray[i];
        }
    }
}

