/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;

public class DataInitRiveh
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.worldgenRatePlants = 35;
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.worldgenRatePlants = 25;
                dataHabitat.worldgenRateTrees = 15;
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SHADE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                dataHabitat.worldgenRateTrees = 20;
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.worldgenRatePlants = 25;
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.worldgenRatePlants = 25;
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.addPlant(DefPlant.EPIPH_CRMIS, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.EPIPH_HARMI, 50, 0, 0, 0);
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.addPlant(DefPlant.MEDIU_WOOLB, 5, 2, 15, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_SWGRA, 50, 3, 25, 1);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addPlant(DefPlant.MEDIU_WOOLB, 50, 3, 15, 1);
                break;
            }
            case LAND_SHADE: {
                dataHabitat.addPlant(DefPlant.FUNGU_BLPOW, 50, 1, 25, 1);
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.PLAIN_SWGRA, 50, 3, 25, 1);
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.SAVAN_TEXTI, 50, 1, 25, 1);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.addPlant(DefPlant.SAVAN_BUTWD, 50, 1, 15, 0);
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.addPlant(DefPlant.FUNGU_BLPOW, 50, 1, 25, 1);
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.addPlant(DefPlant.FRESH_COONT, 35, 3, 25, 1);
                dataHabitat.addPlant(DefPlant.FRESH_MONDG, 50, 3, 25, 1);
                dataHabitat.addPlant(DefPlant.FRESH_WRWAN, 5, 3, 25, 1);
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                dataHabitat.addTree(DefTree.ACACI_CUCUM, 50);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addTree(DefTree.ACACI_RIVBU, 50);
                break;
            }
            case LAND_WATER_EDGE: {
                break;
            }
        }
    }
}

