/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import pmp.core.data.DataHabitatPlant;
import pmp.core.data.DataHabitatTree;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefHabitat;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;
import pmp.core.type.TypeBiome;

public class DataHabitat {
    public final TypeBiome biome;
    public final DefHabitat habitat;
    public int worldgenRatePlants;
    public int worldgenRateTrees;
    private Map<DefPlant, DataHabitatPlant> plants = new TreeMap<DefPlant, DataHabitatPlant>();
    private Map<DefTree, DataHabitatTree> trees = new TreeMap<DefTree, DataHabitatTree>();

    public DataHabitat(TypeBiome biome, DefHabitat habitat) {
        this.biome = biome;
        this.habitat = habitat;
        this.initSettings(false);
    }

    public void initSettings(boolean useDefaultSettings) {
        this.worldgenRatePlants = useDefaultSettings ? this.biome.defaultGenRatePlants : 0;
        this.worldgenRateTrees = useDefaultSettings ? this.biome.defaultGenRateTrees : 0;
    }

    public void applyDefaultHabitatSettings(DataInit dataInit) {
        dataInit.applyDefaultHabitatSettings(this);
    }

    public void applyDefaultHabitatPlants(DataInit dataInit, boolean addDefaultPlants) {
        this.clearHabitatPlants();
        if (addDefaultPlants) {
            dataInit.applyDefaultHabitatPlants(this);
        }
    }

    public void applyDefaultHabitatTrees(DataInit dataInit, boolean addDefaultTrees) {
        this.clearHabitatTrees();
        if (addDefaultTrees) {
            dataInit.applyDefaultHabitatTrees(this);
        }
    }

    public Map<DefPlant, DataHabitatPlant> getPlants() {
        return this.plants;
    }

    public Map<DefTree, DataHabitatTree> getTrees() {
        return this.trees;
    }

    public DataHabitatPlant getHabitatPlantData(DefPlant defPlant) {
        return this.plants.get(defPlant);
    }

    public DataHabitatTree getHabitatTreeData(DefTree defTree) {
        return this.trees.get((Object)defTree);
    }

    public void clearHabitatPlants() {
        this.plants.clear();
    }

    public void clearHabitatTrees() {
        this.trees.clear();
    }

    public void addPlant(DefPlant defPlant, int spawnWeight, int clusterRadius, int clusterChance, int maxElevRange) {
        DataHabitatPlant dataHabitatPlant = this.plants.get(defPlant);
        if (dataHabitatPlant == null) {
            dataHabitatPlant = new DataHabitatPlant(this.habitat, defPlant, spawnWeight, clusterRadius, clusterChance, maxElevRange);
            if (dataHabitatPlant != null) {
                this.plants.put(defPlant, dataHabitatPlant);
            }
        } else {
            dataHabitatPlant.spawnWeight = spawnWeight;
            dataHabitatPlant.clusterRadius = clusterRadius;
            dataHabitatPlant.clusterChance = clusterChance;
            dataHabitatPlant.maxElevRange = maxElevRange;
        }
    }

    public void addTree(DefTree defTree, int spawnWeight) {
        DataHabitatTree dataHabitatTree = this.trees.get((Object)defTree);
        if (dataHabitatTree == null) {
            dataHabitatTree = new DataHabitatTree(this.habitat, defTree, spawnWeight);
            if (dataHabitatTree != null) {
                this.trees.put(defTree, dataHabitatTree);
            }
        } else {
            dataHabitatTree.spawnWeight = spawnWeight;
        }
    }

    public void removePlant(DefPlant defPlant) {
        DataHabitatPlant dataHabitatPlant = this.plants.get(defPlant);
        if (dataHabitatPlant != null) {
            this.getPlants().remove(defPlant);
        }
    }

    public void removeTree(DefTree defTree) {
        DataHabitatTree dataHabitatTree = this.trees.get((Object)defTree);
        if (dataHabitatTree != null) {
            this.trees.remove((Object)defTree);
        }
    }

    public DataHabitatPlant getRandomPlant(Random random) {
        int spawnWeight;
        if (this.plants.size() == 0) {
            return null;
        }
        HashSet<DataHabitatPlant> hs = new HashSet<DataHabitatPlant>();
        int totalWeight = 0;
        for (Map.Entry<DefPlant, DataHabitatPlant> entry : this.plants.entrySet()) {
            spawnWeight = entry.getValue().spawnWeight;
            if (spawnWeight <= 0) continue;
            totalWeight += spawnWeight;
            hs.add(entry.getValue());
        }
        if (totalWeight < 1) {
            return null;
        }
        int randomSelection = random.nextInt(totalWeight);
        spawnWeight = 0;
        for (DataHabitatPlant spawnData : hs) {
            if ((spawnWeight += spawnData.spawnWeight) < randomSelection) continue;
            return spawnData;
        }
        return null;
    }

    public DataHabitatPlant getRandomPlantNoWeighting(Random random) {
        if (this.plants.size() == 0) {
            return null;
        }
        int randIndex = random.nextInt(this.plants.size());
        int index = 0;
        for (Map.Entry<DefPlant, DataHabitatPlant> entry : this.plants.entrySet()) {
            if (index == randIndex) {
                return entry.getValue();
            }
            ++index;
        }
        return null;
    }

    public DataHabitatTree getRandomTree(Random random) {
        int spawnWeight;
        if (this.trees.size() == 0) {
            return null;
        }
        HashSet<DataHabitatTree> hs = new HashSet<DataHabitatTree>();
        int totalWeight = 0;
        for (Map.Entry<DefTree, DataHabitatTree> entry : this.trees.entrySet()) {
            spawnWeight = entry.getValue().spawnWeight;
            if (spawnWeight <= 0) continue;
            totalWeight += spawnWeight;
            hs.add(entry.getValue());
        }
        if (totalWeight < 1) {
            return null;
        }
        int randomSelection = random.nextInt(totalWeight);
        spawnWeight = 0;
        for (DataHabitatTree spawnData : hs) {
            if ((spawnWeight += spawnData.spawnWeight) < randomSelection) continue;
            return spawnData;
        }
        return null;
    }

    public DataHabitatTree getRandomTreeNoWeighting(Random random) {
        if (this.trees.size() == 0) {
            return null;
        }
        int randIndex = random.nextInt(this.trees.size());
        int index = 0;
        for (Map.Entry<DefTree, DataHabitatTree> entry : this.trees.entrySet()) {
            if (index == randIndex) {
                return entry.getValue();
            }
            ++index;
        }
        return null;
    }

    public void loadSettings(String dataLine) {
        DefTree tree;
        String[] data = dataLine.split("|");
        if (data[0].equals("c")) {
            this.loadConfigSetting(data[1]);
        } else if (data[0].equals("p")) {
            DefPlant plant = DefPlant.getPlantFromName(data[1]);
            if (plant != null) {
                DataHabitatPlant dataPlant = this.plants.get(plant);
                if (dataPlant == null) {
                    dataPlant = new DataHabitatPlant(this.habitat, plant);
                    this.plants.put(plant, dataPlant);
                }
                dataPlant.loadSettings(data[2]);
            }
        } else if (data[0].equals("t") && (tree = DefTree.getTreeFromName(data[1])) != null) {
            DataHabitatTree dataTree = this.trees.get((Object)tree);
            if (dataTree == null) {
                dataTree = new DataHabitatTree(this.habitat, tree);
                this.trees.put(tree, dataTree);
            }
            dataTree.loadSettings(data[2]);
        }
    }

    private void loadConfigSetting(String dataLine) {
        String[] data = dataLine.split(",");
        if (data[0].equals("worldgenRatePlants")) {
            this.worldgenRatePlants = Integer.valueOf(data[1]);
        } else if (data[0].equals("worldgenRateTrees")) {
            this.worldgenRateTrees = Integer.valueOf(data[1]);
        }
    }

    public void saveSettings(PrintWriter pw) {
        pw.println(String.format("h.%s:c|worldgenRatePlants,%d", this.habitat.habitatName, this.worldgenRatePlants));
        pw.println(String.format("h.%s:c|worldgenRateTrees,%d", this.habitat.habitatName, this.worldgenRateTrees));
        this.plants.forEach((k, v) -> v.saveSettings(pw));
        this.trees.forEach((k, v) -> v.saveSettings(pw));
    }
}

