/*
 * Decompiled with CFR 0.152.
 */
package pmp.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import pmp.PlantMegaPack;
import pmp.core.ModHelpers;
import pmp.core.data.DataBiome;
import pmp.core.type.TypeBiome;

public class ModSettings {
    private final File settingsFile;
    public Map<TypeBiome, DataBiome> biomeSettings = new HashMap<TypeBiome, DataBiome>(TypeBiome.values().length);
    public int lootSeedsDesertPyramid;
    public int lootSeedsIgloo;
    public int lootSeedsJungleTemple;
    public int lootSeedsMineshaft;
    public int lootSeedsWoodlandMansion;
    public int lootSeedsVillageBlacksmith;
    public boolean plantBambooDropsOnBreak;
    public int plantBambooMaxHeight;
    public boolean plantBerryFastHarvest;
    public int plantClimbingMaxHeight;
    public int plantHangingMaxHeight;
    public boolean plantKelpCanGrow;
    public int plantKelpMaxHeight;
    public int pottingTableOutput;
    public int powderConditionerRadius;
    public int powderConditionerUses;
    public int powderDefoliantRadius;
    public int powderDefoliantUses;
    public int powderFertilizerRadius;
    public int powderFertilizerUses;
    public boolean realismCropCentered;
    public boolean realismPoison;
    public boolean realismSolidLargePlants;
    public boolean realismSolidMediumPlants;
    public boolean realismThorns;
    public int salveAmountHealth;
    public int salveDurationFireResist;
    public int salveDurationInvisibility;
    public int salveDurationLeaping;
    public int salveDurationNightVision;
    public int salveDurationStrength;
    public int salveDurationSwiftness;
    public int salveDurationWaterBreathing;
    public boolean tooltipHints;
    public boolean tooltipOreDictName;
    public boolean tooltipPlantCategory;
    public boolean tooltipPlantParts;
    public int worldgenMasterGenRate;
    public boolean worldgenModDimensions;
    public boolean worldgenSpawnPlants;
    public boolean worldgenSpawnTrees;
    public int worldgenTempDetectRadius;
    public int worldgenBiomeEdgeDetectRadius;
    public int worldgenThresholdSlope;
    public int worldgenThresholdTreeSpawnRadius;
    public boolean worldgenUseWorldSeed;

    public ModSettings(String rootPath) {
        this.settingsFile = new File(rootPath + "settings.cfg");
        ModHelpers.createDirectory(rootPath);
        for (TypeBiome typeBiome : TypeBiome.values()) {
            this.biomeSettings.put(typeBiome, new DataBiome(typeBiome));
        }
    }

    public void initDefaultSettings() {
        this.resetAllWorldgenSettings(true);
        this.resetLootSeedDefaults();
        this.resetPlantDefaults();
        this.resetPottingTableDefaults();
        this.resetPowderDefaults();
        this.resetRealismDefaults();
        this.resetSalveDefaults();
        this.resetTooltipDefaults();
        this.loadSettings();
        this.loadAllBiomeSettings();
    }

    public void resetLootSeedDefaults() {
        this.lootSeedsDesertPyramid = 1;
        this.lootSeedsIgloo = 0;
        this.lootSeedsJungleTemple = 1;
        this.lootSeedsMineshaft = 1;
        this.lootSeedsWoodlandMansion = 1;
        this.lootSeedsVillageBlacksmith = 1;
    }

    public void resetPlantDefaults() {
        this.plantBambooDropsOnBreak = true;
        this.plantBambooMaxHeight = 10;
        this.plantBerryFastHarvest = true;
        this.plantClimbingMaxHeight = 10;
        this.plantHangingMaxHeight = 10;
        this.plantKelpCanGrow = false;
        this.plantKelpMaxHeight = 10;
    }

    public void resetPottingTableDefaults() {
        this.pottingTableOutput = 8;
    }

    public void resetPowderDefaults() {
        this.powderConditionerRadius = 3;
        this.powderConditionerUses = 20;
        this.powderDefoliantRadius = 3;
        this.powderDefoliantUses = 20;
        this.powderFertilizerRadius = 3;
        this.powderFertilizerUses = 20;
    }

    public void resetRealismDefaults() {
        this.realismCropCentered = false;
        this.realismPoison = false;
        this.realismSolidLargePlants = false;
        this.realismSolidMediumPlants = false;
        this.realismThorns = true;
    }

    public void resetSalveDefaults() {
        this.salveAmountHealth = 20;
        this.salveDurationFireResist = 30;
        this.salveDurationInvisibility = 30;
        this.salveDurationLeaping = 30;
        this.salveDurationNightVision = 30;
        this.salveDurationStrength = 30;
        this.salveDurationSwiftness = 30;
        this.salveDurationWaterBreathing = 30;
    }

    public void resetTooltipDefaults() {
        this.tooltipHints = true;
        this.tooltipOreDictName = false;
        this.tooltipPlantCategory = true;
        this.tooltipPlantParts = true;
    }

    public void resetAllWorldgenSettings(boolean useDefaultSettings) {
        for (TypeBiome typeBiome : TypeBiome.values()) {
            DataBiome dataBiome = this.biomeSettings.get((Object)typeBiome);
            if (dataBiome == null) continue;
            dataBiome.initAllDefaultSettings(useDefaultSettings);
        }
        this.resetWorldgenMasterSettings();
        this.resetWorldgenSettings();
    }

    public void resetWorldgenMasterSettings() {
        this.worldgenSpawnPlants = true;
        this.worldgenSpawnTrees = true;
        this.worldgenMasterGenRate = 100;
    }

    public void resetWorldgenSettings() {
        this.worldgenModDimensions = false;
        this.worldgenUseWorldSeed = true;
        this.worldgenTempDetectRadius = 6;
        this.worldgenBiomeEdgeDetectRadius = 2;
        this.worldgenThresholdSlope = 20;
        this.worldgenThresholdTreeSpawnRadius = 2;
    }

    public boolean loadSettings() {
        try {
            if (!this.settingsFile.exists()) {
                return this.saveSettings();
            }
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.settingsFile));
            String line = "";
            while ((line = bufferedreader.readLine()) != null) {
                String[] data = line.split(":");
                if (data[0].equals("lootSeedsDesertPyramid")) {
                    this.lootSeedsDesertPyramid = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("lootSeedsIgloo")) {
                    this.lootSeedsIgloo = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("lootSeedsJungleTemple")) {
                    this.lootSeedsJungleTemple = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("lootSeedsMineshaft")) {
                    this.lootSeedsMineshaft = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("lootSeedsWoodlandMansion")) {
                    this.lootSeedsWoodlandMansion = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("lootSeedsVillageBlacksmith")) {
                    this.lootSeedsVillageBlacksmith = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("plantBambooDropsOnBreak")) {
                    this.plantBambooDropsOnBreak = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("plantBambooMaxHeight")) {
                    this.plantBambooMaxHeight = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("plantBerryFastHarvest")) {
                    this.plantBerryFastHarvest = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("plantClimbingMaxHeight")) {
                    this.plantClimbingMaxHeight = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("plantHangingMaxHeight")) {
                    this.plantHangingMaxHeight = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("plantKelpCanGrow")) {
                    this.plantKelpCanGrow = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("plantKelpMaxHeight")) {
                    this.plantKelpMaxHeight = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("pottingTableOutput")) {
                    this.pottingTableOutput = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("powderConditionerRadius")) {
                    this.powderConditionerRadius = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("powderConditionerUses")) {
                    this.powderConditionerUses = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("powderDefoliantRadius")) {
                    this.powderDefoliantRadius = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("powderDefoliantUses")) {
                    this.powderDefoliantUses = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("powderFertilizerRadius")) {
                    this.powderFertilizerRadius = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("powderFertilizerUses")) {
                    this.powderFertilizerUses = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("realismCropCentered")) {
                    this.realismCropCentered = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("realismPoison")) {
                    this.realismPoison = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("realismSolidLargePlants")) {
                    this.realismSolidLargePlants = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("realismSolidMediumPlants")) {
                    this.realismSolidMediumPlants = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("realismThorns")) {
                    this.realismThorns = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("salveAmountHealth")) {
                    this.salveAmountHealth = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("salveDurationFireResist")) {
                    this.salveDurationFireResist = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("salveDurationInvisibility")) {
                    this.salveDurationInvisibility = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("salveDurationLeaping")) {
                    this.salveDurationLeaping = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("salveDurationNightVision")) {
                    this.salveDurationNightVision = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("salveDurationStrength")) {
                    this.salveDurationStrength = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("salveDurationSwiftness")) {
                    this.salveDurationSwiftness = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("salveDurationWaterBreathing")) {
                    this.salveDurationWaterBreathing = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("tooltipHints")) {
                    this.tooltipHints = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("tooltipOreDictName")) {
                    this.tooltipOreDictName = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("tooltipPlantCategory")) {
                    this.tooltipPlantCategory = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("tooltipPlantParts")) {
                    this.tooltipPlantParts = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("worldgenMasterGenRate")) {
                    this.worldgenMasterGenRate = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("worldgenModDimensions")) {
                    this.worldgenModDimensions = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("worldgenSpawnPlants")) {
                    this.worldgenSpawnPlants = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("worldgenSpawnTrees")) {
                    this.worldgenSpawnTrees = data[1].equals("true");
                    continue;
                }
                if (data[0].equals("worldgenTempDetectRadius")) {
                    this.worldgenTempDetectRadius = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("worldgenBiomeEdgeDetectRadius")) {
                    this.worldgenBiomeEdgeDetectRadius = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("worldgenThresholdSlope")) {
                    this.worldgenThresholdSlope = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("worldgenThresholdTreeSpawnRadius")) {
                    this.worldgenThresholdTreeSpawnRadius = Integer.parseInt(data[1]);
                    continue;
                }
                if (data[0].equals("worldgenUseWorldSeed")) {
                    this.worldgenUseWorldSeed = data[1].equals("true");
                    continue;
                }
                PlantMegaPack.instance.logOutput(Level.WARN, String.format("Invalid config line \"%s\" ignored", line));
            }
            bufferedreader.close();
        }
        catch (Exception e) {
            PlantMegaPack.instance.logOutput(Level.ERROR, "Load config file settings.cfg FAILED");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean saveSettings() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.settingsFile));
            printwriter.println("lootSeedsDesertPyramid:" + this.lootSeedsDesertPyramid);
            printwriter.println("lootSeedsIgloo:" + this.lootSeedsIgloo);
            printwriter.println("lootSeedsJungleTemple:" + this.lootSeedsJungleTemple);
            printwriter.println("lootSeedsMineshaft:" + this.lootSeedsMineshaft);
            printwriter.println("lootSeedsWoodlandMansion:" + this.lootSeedsWoodlandMansion);
            printwriter.println("lootSeedsVillageBlacksmith:" + this.lootSeedsVillageBlacksmith);
            printwriter.println("plantBambooDropsOnBreak:" + this.plantBambooDropsOnBreak);
            printwriter.println("plantBambooMaxHeight:" + this.plantBambooMaxHeight);
            printwriter.println("plantBerryFastHarvest:" + this.plantBerryFastHarvest);
            printwriter.println("plantClimbingMaxHeight:" + this.plantClimbingMaxHeight);
            printwriter.println("plantHangingMaxHeight:" + this.plantHangingMaxHeight);
            printwriter.println("plantKelpCanGrow:" + this.plantKelpCanGrow);
            printwriter.println("plantKelpMaxHeight:" + this.plantKelpMaxHeight);
            printwriter.println("pottingTableOutput:" + this.pottingTableOutput);
            printwriter.println("powderConditionerRadius:" + this.powderConditionerRadius);
            printwriter.println("powderConditionerUses:" + this.powderConditionerUses);
            printwriter.println("powderDefoliantRadius:" + this.powderDefoliantRadius);
            printwriter.println("powderDefoliantUses:" + this.powderDefoliantUses);
            printwriter.println("powderFertilizerRadius:" + this.powderFertilizerRadius);
            printwriter.println("powderFertilizerUses:" + this.powderFertilizerUses);
            printwriter.println("realismCropCentered:" + this.realismCropCentered);
            printwriter.println("realismPoison:" + this.realismPoison);
            printwriter.println("realismSolidLargePlants:" + this.realismSolidLargePlants);
            printwriter.println("realismSolidMediumPlants:" + this.realismSolidMediumPlants);
            printwriter.println("realismThorns:" + this.realismThorns);
            printwriter.println("salveAmountHealth:" + this.salveAmountHealth);
            printwriter.println("salveDurationFireResist:" + this.salveDurationFireResist);
            printwriter.println("salveDurationInvisibility:" + this.salveDurationInvisibility);
            printwriter.println("salveDurationLeaping:" + this.salveDurationLeaping);
            printwriter.println("salveDurationNightVision:" + this.salveDurationNightVision);
            printwriter.println("salveDurationStrength:" + this.salveDurationStrength);
            printwriter.println("salveDurationSwiftness:" + this.salveDurationSwiftness);
            printwriter.println("salveDurationWaterBreathing:" + this.salveDurationWaterBreathing);
            printwriter.println("tooltipHints:" + this.tooltipHints);
            printwriter.println("tooltipOreDictName:" + this.tooltipOreDictName);
            printwriter.println("tooltipPlantCategory:" + this.tooltipPlantCategory);
            printwriter.println("tooltipPlantParts:" + this.tooltipPlantParts);
            printwriter.println("worldgenMasterGenRate:" + this.worldgenMasterGenRate);
            printwriter.println("worldgenModDimensions:" + this.worldgenModDimensions);
            printwriter.println("worldgenSpawnPlants:" + this.worldgenSpawnPlants);
            printwriter.println("worldgenSpawnTrees:" + this.worldgenSpawnTrees);
            printwriter.println("worldgenTempDetectRadius:" + this.worldgenTempDetectRadius);
            printwriter.println("worldgenBiomeEdgeDetectRadius:" + this.worldgenBiomeEdgeDetectRadius);
            printwriter.println("worldgenThresholdSlope:" + this.worldgenThresholdSlope);
            printwriter.println("worldgenThresholdTreeSpawnRadius:" + this.worldgenThresholdTreeSpawnRadius);
            printwriter.println("worldgenUseWorldSeed:" + this.worldgenUseWorldSeed);
            printwriter.close();
        }
        catch (Exception e) {
            PlantMegaPack.instance.logOutput(Level.ERROR, "Save config file settings.cfg FAILED");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void loadAllBiomeSettings() {
        for (TypeBiome biome : TypeBiome.values()) {
            this.loadBiomeSettings(biome);
        }
    }

    public void loadBiomeSettings(TypeBiome biome) {
        DataBiome dataBiome = this.biomeSettings.get((Object)biome);
        if (dataBiome == null) {
            PlantMegaPack.instance.logOutput(Level.ERROR, "Load biome settings FAILED - biome data is null");
            return;
        }
        File dataFile = new File(String.format("%sbiome_%s.cfg", PlantMegaPack.configPathRoot, biome.resourceName));
        try {
            if (!dataFile.exists()) {
                this.saveBiomeSettings(biome);
                return;
            }
            BufferedReader bufferedreader = new BufferedReader(new FileReader(dataFile));
            String line = "";
            while ((line = bufferedreader.readLine()) != null) {
                dataBiome.loadSettings(line);
            }
            bufferedreader.close();
        }
        catch (Exception e) {
            PlantMegaPack.instance.logOutput(Level.ERROR, String.format("Load config file for biome '%s' FAILED", biome.resourceName));
            e.printStackTrace();
        }
    }

    public void saveAllBiomeSettings() {
        for (TypeBiome biome : TypeBiome.values()) {
            this.saveBiomeSettings(biome);
        }
    }

    public void saveBiomeSettings(TypeBiome biome) {
        DataBiome dataBiome = this.biomeSettings.get((Object)biome);
        if (dataBiome == null) {
            PlantMegaPack.instance.logOutput(Level.ERROR, "Save biome settings FAILED - biome data is null");
            return;
        }
        File dataFile = new File(String.format("%sbiome_%s.cfg", PlantMegaPack.configPathRoot, biome.resourceName));
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(dataFile));
            dataBiome.saveSettings(printwriter);
            printwriter.close();
        }
        catch (Exception e) {
            PlantMegaPack.instance.logOutput(Level.ERROR, String.format("Save config file for biome '%s' FAILED", biome.resourceName));
            e.printStackTrace();
        }
    }
}

