/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pmp.PlantMegaPack;
import pmp.block.BlockBasePlant;
import pmp.core.ModHelpers;
import pmp.core.def.DefPlant;
import pmp.core.variant.VariantBlockHalf;

public class BlockPlantMedium
extends BlockBasePlant {
    public static final PropertyEnum<VariantBlockHalf> SEGMENT = PropertyEnum.func_177709_a((String)"segment", VariantBlockHalf.class);
    protected static final AxisAlignedBB AABB_TOP = new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);

    public BlockPlantMedium(DefPlant defPlant) {
        super(defPlant);
        this.func_180632_j(this.func_176223_P().func_177226_a(SEGMENT, (Comparable)((Object)VariantBlockHalf.BOTTOM)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SEGMENT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SEGMENT, (Comparable)((Object)VariantBlockHalf.byMetadata(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= ((VariantBlockHalf)((Object)state.func_177229_b(SEGMENT))).getMetadata();
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return false;
        }
        IBlockState stateBelow = world.func_180495_p(pos.func_177977_b());
        if ((VariantBlockHalf)((Object)state.func_177229_b(SEGMENT)) == VariantBlockHalf.TOP) {
            return stateBelow.func_177230_c() == this && (VariantBlockHalf)((Object)stateBelow.func_177229_b(SEGMENT)) == VariantBlockHalf.BOTTOM;
        }
        return super.func_180671_f(world, pos, state);
    }

    protected void func_176475_e(World world, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(world, pos, state)) {
            if ((VariantBlockHalf)((Object)state.func_177229_b(SEGMENT)) == VariantBlockHalf.BOTTOM) {
                this.func_176226_b(world, pos, state, 0);
            }
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        this.destroyAllBlockSegments(world, pos, state);
        super.func_176206_d(world, pos, state);
    }

    protected void destroyAllBlockSegments(World world, BlockPos pos, IBlockState state) {
        VariantBlockHalf position = (VariantBlockHalf)((Object)state.func_177229_b(SEGMENT));
        if (position == VariantBlockHalf.TOP) {
            world.func_175698_g(pos.func_177977_b());
        } else {
            world.func_175698_g(pos.func_177984_a());
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(SEGMENT, (Comparable)((Object)VariantBlockHalf.TOP)), 3);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if ((VariantBlockHalf)((Object)state.func_177229_b(SEGMENT)) == VariantBlockHalf.BOTTOM) {
            return ModHelpers.getPlantAABB(AABB_BOTTOM, pos);
        }
        if ((VariantBlockHalf)((Object)state.func_177229_b(SEGMENT)) == VariantBlockHalf.TOP) {
            return ModHelpers.getPlantAABB(AABB_TOP, pos);
        }
        return Block.field_185505_j;
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean flag) {
        if (PlantMegaPack.settings.realismSolidMediumPlants) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185900_c((IBlockAccess)world, pos));
            return;
        }
        super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, flag);
    }
}

