/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page.abstr;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.page.abstr.PageDoubleRecipe;
import vazkii.patchouli.common.base.Patchouli;

public abstract class PageDoubleRecipeRegistry<T extends IRecipe<?>>
extends PageDoubleRecipe<T> {
    private static final Method GET_RECIPE_MAP = ObfuscationReflectionHelper.findMethod(RecipeManager.class, (String)"func_215366_a", (Class[])new Class[]{IRecipeType.class});
    private final IRecipeType<? extends T> recipeType;

    public PageDoubleRecipeRegistry(IRecipeType<? extends T> recipeType) {
        this.recipeType = recipeType;
    }

    @Nullable
    private T getRecipe(ResourceLocation id) {
        RecipeManager manager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        try {
            Map recipes = (Map)GET_RECIPE_MAP.invoke((Object)manager, this.recipeType);
            return (T)((IRecipe)recipes.get(id));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Patchouli.LOGGER.error("Failed to get recipe map", (Throwable)e);
            return null;
        }
    }

    @Override
    protected T loadRecipe(BookEntry entry, ResourceLocation res) {
        if (res == null) {
            return null;
        }
        T tempRecipe = this.getRecipe(res);
        if (tempRecipe == null) {
            tempRecipe = this.getRecipe(new ResourceLocation("crafttweaker", res.func_110623_a()));
        }
        if (tempRecipe != null) {
            entry.addRelevantStack(tempRecipe.func_77571_b(), this.pageNum);
            return tempRecipe;
        }
        return null;
    }
}

