/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.common;

import com.parachute.common.Parachute;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityParachute
extends Entity {
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private double motionFactor;
    private double maxAltitude;
    private boolean allowThermals = Parachute.instance.getAllowThermals();
    private boolean smallCanopy;
    private boolean lavaThermals;
    private boolean ridingThermals;
    private double lavaDistance;
    private double maxThermalRise;
    private double curLavaDistance;
    private boolean weatherAffectsDrift;
    private boolean allowTurbulence;
    private boolean showContrails;
    static final double drift = 0.004;
    static final double ascend = -0.04;
    static final int modeDrift = 0;
    static final int modeAscend = 1;
    static final double forwardSpeed = 0.75;
    private final double d2r = 0.0174532925199433;
    private final double r2d = 57.2957795130823;
    private static boolean ascendMode;

    public EntityParachute(World world) {
        super(world);
        this.maxAltitude = Parachute.instance.getMaxAltitude();
        this.smallCanopy = Parachute.instance.isSmallCanopy();
        this.weatherAffectsDrift = Parachute.instance.getWeatherAffectsDrift();
        this.allowTurbulence = Parachute.instance.getAllowturbulence();
        this.showContrails = Parachute.instance.getShowContrails();
        this.lavaDistance = Parachute.instance.getMinLavaDistance();
        this.allowThermals = Parachute.instance.getAllowThermals();
        this.maxAltitude = Parachute.instance.getMaxAltitude();
        this.lavaThermals = Parachute.instance.getAllowLavaThermals();
        this.curLavaDistance = this.lavaDistance;
        this.field_70156_m = true;
        this.func_70105_a(2.0f, 1.0f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.motionFactor = 0.07;
        ascendMode = false;
        this.ridingThermals = false;
        this.maxThermalRise = 48.0;
    }

    public EntityParachute(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y + (double)this.field_70129_M, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public static void setAscendMode(boolean mode) {
        ascendMode = mode;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public boolean shouldDismountInWater(Entity rider) {
        return true;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity != this.field_70153_n && entity.field_70154_o != this) {
            return entity.field_70121_D;
        }
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return this.smallCanopy ? -2.5 : -3.5;
    }

    public void destroyParachute() {
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int inc) {
        double deltaX = x - this.field_70165_t;
        double deltaY = y - this.field_70163_u;
        double deltaZ = z - this.field_70161_v;
        double magnitude = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        if (magnitude <= 1.0) {
            return;
        }
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.velocityX = this.field_70159_w = x;
        this.velocityY = this.field_70181_x = y;
        this.velocityZ = this.field_70179_y = z;
    }

    public void func_70071_h_() {
        double adjustedYaw;
        double localvelocity;
        double offset;
        super.func_70071_h_();
        if (this.field_70153_n == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.destroyParachute();
            }
            return;
        }
        double velocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (this.showContrails) {
            this.showContrails(velocity);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (Parachute.instance.isAutoDismount() && this.checkShouldDropChute(this.field_70165_t, this.field_70163_u, this.field_70161_v, (offset = Math.abs(this.func_70042_X())) + 1.0)) {
            return;
        }
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
            double forwardMovement;
            EntityLivingBase rider = (EntityLivingBase)this.field_70153_n;
            double d = forwardMovement = this.allowThermals ? (double)rider.field_70701_bs : 0.75;
            if (forwardMovement > 0.0) {
                double f = (double)rider.field_70177_z + (double)(-rider.field_70702_br) * 90.0;
                this.field_70159_w += -Math.sin(f * 0.0174532925199433) * this.motionFactor * 0.05 * forwardMovement;
                this.field_70179_y += Math.cos(f * 0.0174532925199433) * this.motionFactor * 0.05 * forwardMovement;
            }
        }
        if ((localvelocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 0.35) {
            double motionAdj = 0.35 / localvelocity;
            this.field_70159_w *= motionAdj;
            this.field_70179_y *= motionAdj;
            localvelocity = 0.35;
        }
        if (localvelocity > velocity && this.motionFactor < 0.35) {
            this.motionFactor += (0.35 - this.motionFactor) / 35.0;
            if (this.motionFactor > 0.35) {
                this.motionFactor = 0.35;
            }
        } else {
            this.motionFactor -= (this.motionFactor - 0.07) / 35.0;
            if (this.motionFactor < 0.07) {
                this.motionFactor = 0.07;
            }
        }
        this.field_70181_x -= this.currentDescentRate();
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.99;
        this.field_70181_x *= 0.95;
        this.field_70179_y *= 0.99;
        this.field_70125_A = 0.0f;
        double yaw = this.field_70177_z;
        double delta_X = this.field_70169_q - this.field_70165_t;
        double delta_Z = this.field_70166_s - this.field_70161_v;
        if (delta_X * delta_X + delta_Z * delta_Z > 0.001) {
            yaw = (float)(Math.atan2(delta_Z, delta_X) * 57.2957795130823);
        }
        if ((adjustedYaw = MathHelper.func_76138_g((double)(yaw - (double)this.field_70177_z))) > 20.0) {
            adjustedYaw = 20.0;
        }
        if (adjustedYaw < -20.0) {
            adjustedYaw = -20.0;
        }
        this.field_70177_z = (float)((double)this.field_70177_z + adjustedYaw);
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if ((this.isBadWeather() || this.allowTurbulence) && this.field_70146_Z.nextBoolean()) {
            this.applyTurbulence(this.field_70170_p.func_72911_I());
        }
        if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
            this.field_70153_n = null;
            if (!this.field_70170_p.field_72995_K) {
                this.destroyParachute();
            }
        }
    }

    public boolean isBadWeather() {
        return this.weatherAffectsDrift && (this.field_70170_p.func_72896_J() || this.field_70170_p.func_72911_I());
    }

    public double currentDescentRate() {
        double descentRate = 0.004;
        if (this.weatherAffectsDrift) {
            if (this.field_70170_p.func_72896_J()) {
                descentRate += 0.002;
            }
            if (this.field_70170_p.func_72911_I()) {
                descentRate += 0.004;
            }
        }
        if (!this.allowThermals && !this.lavaThermals) {
            return descentRate;
        }
        if (this.lavaThermals) {
            descentRate = this.doLavaThermals();
            return descentRate;
        }
        if (ascendMode) {
            descentRate = -0.04;
        }
        if (this.maxAltitude > 0.0 && this.field_70163_u >= this.maxAltitude) {
            descentRate = 0.004;
        }
        return descentRate;
    }

    public boolean isLavaAt(double posx, double posy, double posz) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)posx);
        Block block = this.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)posy), z = MathHelper.func_76128_c((double)posz));
        return block == Blocks.field_150353_l || block == Blocks.field_150356_k;
    }

    public boolean isLavaBelowInRange(double posx, double posy, double posz) {
        Vec3 v2;
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        Vec3 v1 = Vec3.func_72443_a((double)x, (double)(y = MathHelper.func_76128_c((double)this.field_70163_u)), (double)(z = MathHelper.func_76128_c((double)this.field_70161_v)));
        MovingObjectPosition mop = this.field_70170_p.func_72901_a(v1, v2 = Vec3.func_72443_a((double)posx, (double)posy, (double)posz), true);
        return mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.isLavaAt(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
    }

    public double doLavaThermals() {
        double thermals = 0.004;
        double offset = Math.abs(this.func_70042_X());
        double inc = 0.5;
        if (this.isLavaBelowInRange(this.field_70165_t, this.field_70163_u - offset - this.maxThermalRise, this.field_70161_v)) {
            this.ridingThermals = true;
            this.curLavaDistance += 0.5;
            thermals = -0.04;
            if (this.curLavaDistance >= this.maxThermalRise) {
                this.ridingThermals = false;
                this.curLavaDistance = this.lavaDistance;
                thermals = 0.004;
            }
        } else {
            this.ridingThermals = false;
            this.curLavaDistance = this.lavaDistance;
        }
        return thermals;
    }

    protected boolean checkShouldDropChute(double x, double y, double z, double distance) {
        boolean shouldDrop = false;
        if (this.isNearGround(x, y, z, distance)) {
            if (this.field_70153_n != null) {
                this.dropParachute(this);
                if (!this.field_70170_p.field_72995_K) {
                    this.destroyParachute();
                } else {
                    this.field_70153_n = null;
                }
            }
            shouldDrop = true;
        }
        return shouldDrop;
    }

    public boolean isNearGround(double posx, double posy, double posz, double distance) {
        boolean isLeafBlock;
        int z;
        int y;
        boolean result = false;
        int x = MathHelper.func_76128_c((double)posx);
        Block block = this.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)(posy - distance)), z = MathHelper.func_76128_c((double)posz));
        boolean bl = isLeafBlock = block == Blocks.field_150362_t || block == Blocks.field_150361_u;
        if (!this.field_70170_p.func_147437_c(x, y, z) && !isLeafBlock) {
            return true;
        }
        return result;
    }

    public void dropParachute(Entity parachute) {
        if (parachute == null) {
            if (this.field_70154_o != null) {
                this.func_70012_b(this.field_70154_o.field_70165_t, this.field_70154_o.field_70121_D.field_72338_b + (double)this.field_70154_o.field_70131_O, this.field_70154_o.field_70161_v, this.field_70177_z, this.field_70125_A);
                this.field_70154_o.field_70153_n = null;
            }
            this.field_70154_o = null;
        } else {
            if (this.field_70154_o != null) {
                this.field_70154_o.field_70153_n = null;
            }
            this.field_70154_o = parachute;
            parachute.field_70153_n = this;
        }
    }

    public void applyTurbulence(boolean roughWeather) {
        double rmin = 0.1;
        double deltaPos = rmin + 0.9 * this.field_70146_Z.nextDouble();
        if (deltaPos >= 0.2) {
            double rmax = roughWeather ? 0.8 : 0.5;
            double deltaX = rmin + (rmax - rmin) * this.field_70146_Z.nextDouble();
            double deltaY = rmin + 0.2 * this.field_70146_Z.nextDouble();
            double deltaZ = rmin + (rmax - rmin) * this.field_70146_Z.nextDouble();
            deltaPos = MathHelper.func_76133_a((double)deltaPos);
            double deltaInv = 1.0 / deltaPos;
            deltaX /= deltaPos;
            deltaY /= deltaPos;
            deltaZ /= deltaPos;
            if (deltaInv > 1.0) {
                deltaInv = 1.0;
            }
            deltaX *= deltaInv;
            deltaY *= deltaInv;
            deltaZ *= deltaInv;
            deltaX *= 0.05;
            deltaY *= 0.05;
            deltaZ *= 0.05;
            if (this.field_70146_Z.nextBoolean()) {
                this.func_70024_g(-deltaX, -deltaY, -deltaZ);
            } else {
                this.func_70024_g(deltaX, deltaY, deltaZ);
            }
        }
    }

    public void showContrails(double velocity) {
        if (velocity >= 0.2) {
            double cosYaw = 2.0 * Math.cos((double)this.field_70177_z * 0.0174532925199433);
            double sinYaw = 2.0 * Math.sin((double)this.field_70177_z * 0.0174532925199433);
            int j = 0;
            while ((double)j < 1.0 + velocity * 15.0) {
                double s1 = ((double)this.field_70146_Z.nextFloat() * 2.0 - 1.0) * 0.2;
                double s2 = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
                double particleX = this.field_70169_q - cosYaw * s1 * -0.1 + sinYaw * s2;
                double particleZ = this.field_70166_s - sinYaw * s1 * -0.1 - cosYaw * s2;
                this.field_70170_p.func_72869_a("smoke", particleX, this.field_70163_u - 0.25, particleZ, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                ++j;
            }
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }
}

