/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.common;

import com.parachute.client.ClientConfiguration;
import com.parachute.common.ConfigHandler;
import com.parachute.common.EntityParachute;
import com.parachute.common.ItemParachute;
import com.parachute.common.ItemParachutePack;
import com.parachute.common.Parachute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerTickEventHandler {
    private boolean displayArmorBar;

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            this.autoActivateDevice(event.player);
            this.togglePlayerParachutePack(event.player);
            this.armorBarRenderingHandler(event.player);
        }
    }

    private void togglePlayerParachutePack(EntityPlayer player) {
        if (player != null) {
            ItemStack armor = player.func_184582_a(Parachute.ARMOR_TYPE);
            ItemStack heldItemMainhand = player.func_184614_ca();
            ItemStack heldItem = !heldItemMainhand.func_190926_b() ? heldItemMainhand : player.func_184586_b(EnumHand.OFF_HAND);
            boolean deployed = player.func_184187_bx() instanceof EntityParachute;
            if (!deployed && armor.func_77973_b() instanceof ItemParachutePack && (heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof ItemParachute))) {
                player.field_71071_by.field_70460_b.set(Parachute.ARMOR_TYPE.func_188454_b(), (Object)ItemStack.field_190927_a);
            } else if (heldItem.func_77973_b() instanceof ItemParachute && armor.func_190926_b()) {
                player.field_71071_by.field_70460_b.set(Parachute.ARMOR_TYPE.func_188454_b(), (Object)new ItemStack(Parachute.ITEM_PARACHUTE_PACK));
            }
        }
    }

    private void armorBarRenderingHandler(EntityPlayer player) {
        if (player != null) {
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                if (!(player.func_184582_a(slot).func_77973_b() instanceof ItemArmor)) continue;
                this.displayArmorBar = !(player.func_184582_a(slot).func_77973_b() instanceof ItemParachutePack);
            }
            if (player.field_70170_p.field_72995_K) {
                GuiIngameForge.renderArmor = this.displayArmorBar;
            }
        }
    }

    private void autoActivateDevice(EntityPlayer player) {
        boolean aadState = player.field_70170_p.field_72995_K ? ClientConfiguration.getAADState() : ConfigHandler.getAADState();
        if (aadState && !(player.func_184187_bx() instanceof EntityParachute)) {
            ItemStack heldItem = null;
            Iterable heldEquipment = player.func_184214_aD();
            for (ItemStack itemStack : heldEquipment) {
                if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemParachute)) continue;
                heldItem = itemStack;
            }
            double AAD_FALL_DISTANCE = 5.0;
            if ((double)player.field_70143_R > AAD_FALL_DISTANCE && heldItem != null && heldItem.func_77973_b() instanceof ItemParachute) {
                ((ItemParachute)heldItem.func_77973_b()).deployParachute(player.field_70170_p, player);
            }
        }
    }
}

