/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.common;

import com.parachute.client.ClientConfiguration;
import com.parachute.client.ParachuteFlyingSound;
import com.parachute.client.RenderParachute;
import com.parachute.common.ClientAADStateMessage;
import com.parachute.common.ConfigHandler;
import com.parachute.common.EntityParachute;
import com.parachute.common.PacketHandler;
import com.parachute.common.Parachute;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemParachute
extends Item {
    private static final double OFFSET = 2.5;

    public ItemParachute(String itemName) {
        this.func_77656_e(Item.ToolMaterial.IRON.func_77997_a());
        this.field_77777_bU = 4;
        this.func_77637_a(CreativeTabs.field_78029_e);
        this.setRegistryName(new ResourceLocation("parachutemod", itemName));
        this.func_77655_b("parachutemod:" + itemName);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityplayer, @Nonnull EnumHand hand) {
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        if (Parachute.isFalling(entityplayer) && entityplayer.func_184187_bx() == null) {
            this.deployParachute(world, entityplayer);
        } else {
            this.toggleAAD(itemstack, world, entityplayer);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void deployParachute(World world, EntityPlayer entityplayer) {
        EntityParachute chute = new EntityParachute(world, entityplayer.field_70165_t, entityplayer.field_70163_u + 2.5, entityplayer.field_70161_v);
        chute.field_70177_z = entityplayer.field_70177_z;
        float volume = 1.0f;
        chute.func_184185_a(Parachute.OPENCHUTE, volume, this.pitch());
        if (world.field_72995_K) {
            RenderParachute.setParachuteColor(ClientConfiguration.getChuteColor());
            this.playFlyingSound(entityplayer);
        } else {
            world.func_72838_d((Entity)chute);
        }
        entityplayer.func_184220_m((Entity)chute);
        entityplayer.func_71064_a((StatBase)Parachute.parachuteDeployed, 1);
        ItemStack itemstack = null;
        Iterable heldEquipment = entityplayer.func_184214_aD();
        for (ItemStack itemStack : heldEquipment) {
            if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemParachute)) continue;
            itemstack = itemStack;
        }
        if (itemstack != null) {
            boolean enchanted;
            boolean bl = enchanted = EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"unbreaking"), itemstack) > 0;
            if (!entityplayer.field_71075_bZ.field_75098_d || !enchanted) {
                itemstack.func_77972_a(ConfigHandler.getParachuteDamageAmount(itemstack), (EntityLivingBase)entityplayer);
            }
        }
    }

    private void toggleAAD(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (entityplayer != null) {
            boolean active = ConfigHandler.getAADState();
            if (!world.field_72995_K) {
                active = !active;
                ConfigHandler.setAADState(active);
                itemstack.func_151001_c(active ? "Parachute|AUTO" : "Parachute");
                PacketHandler.NETWORK.sendTo((IMessage)new ClientAADStateMessage(active), (EntityPlayerMP)entityplayer);
            } else {
                world.func_184133_a(entityplayer, new BlockPos(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v), SoundEvents.field_187909_gi, SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
    }

    private float pitch() {
        return 1.0f / (field_77697_d.nextFloat() * 0.4f + 0.8f);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return Items.field_151007_F == repair.func_77973_b();
    }

    @SideOnly(value=Side.CLIENT)
    private void playFlyingSound(EntityPlayer entityplayer) {
        if (ClientConfiguration.getUseFlyingSoud()) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ParachuteFlyingSound(entityplayer));
        }
    }
}

