/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.mod;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import subaraki.paintings.utils.CommonConfig;

public class ConfigData {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    public static void refreshClient() {
        CommonConfig.show_painting_size = (Boolean)ConfigData.CLIENT.show_painting_size.get();
    }

    public static void refreshServer() {
        CommonConfig.use_vanilla_only = (Boolean)ConfigData.SERVER.use_vanilla_only.get();
        CommonConfig.use_selection_gui = (Boolean)ConfigData.SERVER.use_selection_gui.get();
        CommonConfig.cycle_paintings = (Boolean)ConfigData.SERVER.cycle_paintings.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue show_painting_size;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.show_painting_size = builder.comment("Pick True to show the size of paintings in the painting gui").translation("translate.show.size").define("show_painting_size", true);
            builder.pop();
        }
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.BooleanValue use_vanilla_only;
        public final ForgeConfigSpec.BooleanValue use_selection_gui;
        public final ForgeConfigSpec.BooleanValue cycle_paintings;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.use_vanilla_only = builder.comment("Pick true to only use the vanilla paintings and skip loading any other paintings").translation("translate.pick.vanilla").define("use_vanilla_only", false);
            this.use_selection_gui = builder.comment("Pick true to enable the Painting Selection Gui tot pop up when placing a painting").translation("translate.pick.psg").define("use_selection_gui", true);
            this.cycle_paintings = builder.comment("Pick True to enable painting cycling on right click with a painting item").translation("translate.cycle.painting").define("cycle_paintings", false);
            builder.pop();
        }
    }
}

