/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<axo, cmt> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(axo entityType, String name, float shadowSize) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, null);
    }

    public ModelAdapter(axo entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(cmt tileEntityType, String name, float shadowSize) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(cmt tileEntityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, aliases);
    }

    public ModelAdapter(Either<axo, cmt> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<axo, cmt> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract eke makeModel();

    public abstract emb getModelRenderer(eke var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(eke var1, float var2);

    public boolean setTextureLocation(IEntityRenderer er, yt textureLocation) {
        return false;
    }

    public emb[] getModelRenderers(eke model) {
        String[] names = this.getModelRendererNames();
        ArrayList<emb> list = new ArrayList<emb>();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            emb mr = this.getModelRenderer(model, name);
            if (mr == null) continue;
            list.add(mr);
        }
        emb[] mrs = list.toArray(new emb[list.size()]);
        return mrs;
    }

    public static emb bakeModelLayer(elz loc) {
        return dyr.D().ab().getContext().a(loc);
    }
}

