/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private axk entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<gj> setLitChunkPos = new HashSet();
    private gj.a blockPosMutable = new gj.a();

    public DynamicLight(axk entity) {
        this.entity = entity;
        this.offsetY = entity.cy();
    }

    public void update(eqq renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.dc() - 0.5;
        double posY = this.entity.de() - 0.5 + this.offsetY;
        double posZ = this.entity.di() - 0.5;
        int lightLevel = DynamicLights.getLightLevel((axk)this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet setNewPos = new HashSet();
        if (lightLevel > 0) {
            go dirX = (ajl.b((double)posX) & 0xF) >= 8 ? go.f : go.e;
            go dirY = (ajl.b((double)posY) & 0xF) >= 8 ? go.b : go.a;
            go dirZ = (ajl.b((double)posZ) & 0xF) >= 8 ? go.d : go.c;
            gj chunkPos = new gj(posX, posY, posZ);
            eth.c chunk = renderGlobal.getRenderChunk(chunkPos);
            gj chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            eth.c chunkX = renderGlobal.getRenderChunk(chunkPosX);
            gj chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            eth.c chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            gj chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            eth.c chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            gj chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            eth.c chunkY = renderGlobal.getRenderChunk(chunkPosY);
            gj chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            eth.c chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            gj chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            eth.c chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            gj chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            eth.c chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private gj getChunkPos(eth.c renderChunk, gj pos, go facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(eth.c renderChunk, Set<gj> setPrevPos, Set<gj> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        eth.b compiledChunk = renderChunk.d();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
            renderChunk.setNeedsBackgroundPriorityUpdate(true);
        }
        gj pos = renderChunk.f().h();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(eqq renderGlobal) {
        for (gj posOld : this.setLitChunkPos) {
            eth.c chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public axk getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

