/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import openmods.integration.IIntegrationModule;
import openperipheral.api.adapter.IScriptType;
import openperipheral.integration.OpcAccess;
import openperipheral.integration.vanilla.AdapterBeacon;
import openperipheral.integration.vanilla.AdapterBrewingStand;
import openperipheral.integration.vanilla.AdapterComparator;
import openperipheral.integration.vanilla.AdapterDaylightSensor;
import openperipheral.integration.vanilla.AdapterFlowerPot;
import openperipheral.integration.vanilla.AdapterFluidHandler;
import openperipheral.integration.vanilla.AdapterFluidTank;
import openperipheral.integration.vanilla.AdapterFurnace;
import openperipheral.integration.vanilla.AdapterMobSpawner;
import openperipheral.integration.vanilla.AdapterNoteBlock;
import openperipheral.integration.vanilla.AdapterRecordPlayer;
import openperipheral.integration.vanilla.AdapterSign;
import openperipheral.integration.vanilla.AdapterSkull;
import openperipheral.integration.vanilla.BurnTimeMetaProvider;
import openperipheral.integration.vanilla.ConverterItemFingerprint;
import openperipheral.integration.vanilla.EnchantedBookMetaProvider;
import openperipheral.integration.vanilla.EnchantmentMetaProvider;
import openperipheral.integration.vanilla.EntityBatMetaProvider;
import openperipheral.integration.vanilla.EntityCreeperMetaProvider;
import openperipheral.integration.vanilla.EntityHorseMetaProvider;
import openperipheral.integration.vanilla.EntityItemMetaProvider;
import openperipheral.integration.vanilla.EntityLivingMetaProvider;
import openperipheral.integration.vanilla.EntityPigMetaProvider;
import openperipheral.integration.vanilla.EntityPlayerMetaProvider;
import openperipheral.integration.vanilla.EntitySheepMetaProvider;
import openperipheral.integration.vanilla.EntityTameableMetaProvider;
import openperipheral.integration.vanilla.EntityVillagerMetaProvider;
import openperipheral.integration.vanilla.EntityWitchMetaProvider;
import openperipheral.integration.vanilla.EntityWolfMetaProvider;
import openperipheral.integration.vanilla.EntityZombieMetaProvider;
import openperipheral.integration.vanilla.FingerprintMetaProvider;
import openperipheral.integration.vanilla.FluidContainerMetaProvider;
import openperipheral.integration.vanilla.InventoryProviderMetaProvider;
import openperipheral.integration.vanilla.ItemArmorMetaProvider;
import openperipheral.integration.vanilla.ItemFingerprint;
import openperipheral.integration.vanilla.ItemFrameMetaProvider;
import openperipheral.integration.vanilla.ItemPotionMetaProvider;
import openperipheral.integration.vanilla.ItemSwordMetaProvider;
import openperipheral.integration.vanilla.ItemToolClassMetaProvider;
import openperipheral.integration.vanilla.ItemToolMetaProvider;
import openperipheral.integration.vanilla.OreDictMetaProvider;
import openperipheral.integration.vanilla.PaintingMetaProvider;

public class ModuleVanilla
implements IIntegrationModule {
    public static String DUMMY_VANILLA_MODID = "vanilla";
    private static final IScriptType FINGERPRINT_TYPE = new IScriptType(){

        @Override
        public String describe() {
            return "{id:string,dmg:number?,nbt_hash:string?}";
        }
    };

    public String name() {
        return "Vanilla CC integration module";
    }

    public boolean canLoad() {
        return true;
    }

    public void load() {
        OpcAccess.adapterRegistry.register(new AdapterNoteBlock());
        OpcAccess.adapterRegistry.register(new AdapterComparator());
        OpcAccess.adapterRegistry.register(new AdapterBeacon());
        OpcAccess.adapterRegistry.register(new AdapterBrewingStand());
        OpcAccess.adapterRegistry.register(new AdapterFluidHandler());
        OpcAccess.adapterRegistry.register(new AdapterFluidTank());
        OpcAccess.adapterRegistry.register(new AdapterFurnace());
        OpcAccess.adapterRegistry.register(new AdapterMobSpawner());
        OpcAccess.adapterRegistry.register(new AdapterRecordPlayer());
        OpcAccess.adapterRegistry.register(new AdapterSign());
        OpcAccess.adapterRegistry.register(new AdapterDaylightSensor());
        OpcAccess.adapterRegistry.register(new AdapterSkull());
        OpcAccess.adapterRegistry.register(new AdapterFlowerPot());
        OpcAccess.itemStackMetaBuilder.register(new EnchantedBookMetaProvider());
        OpcAccess.itemStackMetaBuilder.register(new EnchantmentMetaProvider());
        OpcAccess.itemStackMetaBuilder.register(new FluidContainerMetaProvider());
        OpcAccess.itemStackMetaBuilder.register(new BurnTimeMetaProvider());
        OpcAccess.itemStackMetaBuilder.register(new OreDictMetaProvider());
        OpcAccess.itemStackMetaBuilder.register(new FingerprintMetaProvider());
        OpcAccess.itemStackMetaBuilder.register(new ItemToolClassMetaProvider());
        OpcAccess.itemStackMetaBuilder.register(new ItemToolMetaProvider());
        OpcAccess.itemStackMetaBuilder.register(new ItemArmorMetaProvider());
        OpcAccess.itemStackMetaBuilder.register(new ItemSwordMetaProvider());
        OpcAccess.itemStackMetaBuilder.register(new ItemPotionMetaProvider());
        OpcAccess.entityMetaBuilder.register(new EntityItemMetaProvider());
        OpcAccess.entityMetaBuilder.register(new PaintingMetaProvider());
        OpcAccess.entityMetaBuilder.register(new ItemFrameMetaProvider());
        OpcAccess.entityMetaBuilder.register(new EntityBatMetaProvider());
        OpcAccess.entityMetaBuilder.register(new EntityCreeperMetaProvider());
        OpcAccess.entityMetaBuilder.register(new EntityHorseMetaProvider());
        OpcAccess.entityMetaBuilder.register(new EntityLivingMetaProvider());
        OpcAccess.entityMetaBuilder.register(new EntityPigMetaProvider());
        OpcAccess.entityMetaBuilder.register(new EntityPlayerMetaProvider());
        OpcAccess.entityMetaBuilder.register(new EntitySheepMetaProvider());
        OpcAccess.entityMetaBuilder.register(new EntityTameableMetaProvider());
        OpcAccess.entityMetaBuilder.register(new EntityVillagerMetaProvider());
        OpcAccess.entityMetaBuilder.register(new EntityWitchMetaProvider());
        OpcAccess.entityMetaBuilder.register(new EntityWolfMetaProvider());
        OpcAccess.entityMetaBuilder.register(new EntityZombieMetaProvider());
        OpcAccess.entityMetaBuilder.register(new InventoryProviderMetaProvider());
        OpcAccess.converterManager.register(new ConverterItemFingerprint());
        OpcAccess.typeClassifier.registerType(ItemFingerprint.class, FINGERPRINT_TYPE);
    }

    public static Object listEnchantments(NBTTagList ench) {
        ArrayList response = Lists.newArrayList();
        for (int i = 0; i < ench.func_74745_c(); ++i) {
            NBTTagCompound enchTag = ench.func_150305_b(i);
            short id = enchTag.func_74765_d("id");
            short lvl = enchTag.func_74765_d("lvl");
            Enchantment enchantment = Enchantment.field_77331_b[id];
            if (enchantment == null) continue;
            HashMap entry = Maps.newHashMap();
            entry.put("name", enchantment.func_77320_a());
            entry.put("level", lvl);
            entry.put("fullName", enchantment.func_77316_c((int)lvl));
            response.add(entry);
        }
        return response;
    }
}

