/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import openmods.geometry.BoundingBoxBuilder;
import openmods.geometry.Box2d;
import openperipheral.addons.glasses.utils.ColorPoint2d;
import openperipheral.addons.glasses.utils.IPointList;
import openperipheral.addons.glasses.utils.IPointListBuilder;
import openperipheral.addons.glasses.utils.PointList;
import openperipheral.addons.glasses.utils.RenderState;
import org.lwjgl.opengl.GL11;

public class ColorPointListBuilder
implements IPointListBuilder<ColorPoint2d> {
    private final List<ColorPoint2d> points = Lists.newArrayList();
    private final BoundingBoxBuilder bbBuilder = BoundingBoxBuilder.create();

    @Override
    public void add(ColorPoint2d point) {
        this.bbBuilder.addPoint(point.x, point.y);
        this.points.add(point);
    }

    private static ColorPoint2d toBoundingBox(Box2d bb, ColorPoint2d point) {
        return new ColorPoint2d(point.x - bb.left, point.y - bb.top, point.rgb, point.opacity);
    }

    @Override
    public IPointList<ColorPoint2d> buildPointList() {
        Box2d bb = this.bbBuilder.build();
        ArrayList relPoints = Lists.newArrayList();
        for (ColorPoint2d p : this.points) {
            relPoints.add(ColorPointListBuilder.toBoundingBox(bb, p));
        }
        return new PointListImpl(relPoints);
    }

    @Override
    public Box2d buildBoundingBox() {
        return this.bbBuilder.build();
    }

    private static class PointListImpl
    extends PointList<ColorPoint2d> {
        public PointListImpl(List<ColorPoint2d> points) {
            super(points);
        }

        @Override
        protected void drawPoint(RenderState renderState, ColorPoint2d p) {
            renderState.setColor(p.rgb, p.opacity);
            GL11.glVertex2f((float)p.x, (float)p.y);
        }
    }
}

