/*
 * Decompiled with CFR 0.152.
 */
package openmods.reflection;

import java.lang.reflect.Field;
import openmods.reflection.ReflectionHelper;

public class FieldAccessHelpers {
    public static int getIntField(Class<?> klazz, Object target, String field) {
        return FieldAccessHelpers.getField(klazz, target, field, -1);
    }

    public static boolean getBooleanField(Class<?> klazz, Object target, String field) {
        return FieldAccessHelpers.getField(klazz, target, field, false);
    }

    public static byte getByteField(Class<?> klazz, Object target, String field) {
        return FieldAccessHelpers.getField(klazz, target, field, (byte)-1);
    }

    public static <T> T getField(Class<?> klazz, Object target, String field, T defaultValue) {
        try {
            Field f = ReflectionHelper.getField(klazz, field);
            Object o = f.get(target);
            if (o != null) {
                return (T)o;
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return defaultValue;
    }
}

