/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import openmods.calc.CommandExecutionException;
import openmods.calc.CommandSyntaxException;
import openmods.calc.HelpPrinter;
import openmods.calc.ICommandComponent;
import openmods.calc.IWhitespaceSplitter;
import openmods.calc.NestedCommandException;
import openmods.utils.CommandUtils;

public class MapCommandComponent
implements ICommandComponent {
    private final Map<String, ICommandComponent> subCommands;

    private MapCommandComponent(Map<String, ICommandComponent> subCommands) {
        this.subCommands = subCommands;
    }

    @Override
    public void execute(ICommandSender sender, IWhitespaceSplitter args) {
        String key = args.getNextPart();
        ICommandComponent subCommand = this.subCommands.get(key);
        if (subCommand == null) {
            throw new CommandSyntaxException("openmodslib.command.no_subcommand", key);
        }
        try {
            subCommand.execute(sender, args);
        }
        catch (NestedCommandException e) {
            throw e.pushCommandName(key);
        }
        catch (Exception e) {
            throw new CommandExecutionException(e).pushCommandName(key);
        }
    }

    @Override
    public ICommandComponent partialyExecute(IWhitespaceSplitter args) {
        String key = args.getNextPart();
        ICommandComponent subCommand = this.subCommands.get(key);
        if (subCommand == null) {
            throw new CommandSyntaxException("openmodslib.command.no_subcommand", key);
        }
        return subCommand;
    }

    @Override
    public void help(HelpPrinter printer) {
        for (Map.Entry<String, ICommandComponent> e : this.subCommands.entrySet()) {
            printer.push(e.getKey());
            e.getValue().help(printer);
            printer.pop();
        }
    }

    @Override
    public List<String> getTabCompletions(IWhitespaceSplitter args) {
        String key = args.getNextPart();
        if (args.isFinished()) {
            return CommandUtils.filterPrefixes(key, this.subCommands.keySet());
        }
        ICommandComponent subCommand = this.subCommands.get(key);
        if (subCommand == null) {
            return ImmutableList.of();
        }
        return subCommand.getTabCompletions(args);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableMap.Builder<String, ICommandComponent> builder = ImmutableMap.builder();

        public Builder put(String command, ICommandComponent commandComponent) {
            this.builder.put((Object)command, (Object)commandComponent);
            return this;
        }

        public ICommandComponent build() {
            return new MapCommandComponent((Map)this.builder.build());
        }
    }
}

