/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.client.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;

public class ElevatorBakedModel
extends BakedModelWrapper<BakedModel> {
    public static final ModelProperty<BlockState> HELD_STATE = new ModelProperty();

    public ElevatorBakedModel(BakedModel originalModel) {
        super(originalModel);
    }

    @Nonnull
    public List<BakedQuad> getQuads(BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState heldState;
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>();
        RenderType layer = MinecraftForgeClient.getRenderType();
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        if (layer == RenderType.m_110457_() && side == null && ((Boolean)state.m_61143_((Property)ElevatorBlock.DIRECTIONAL)).booleanValue() && ((Boolean)state.m_61143_((Property)ElevatorBlock.SHOW_ARROW)).booleanValue()) {
            BakedModel arrowModel = dispatcher.m_110907_().m_110881_().getModel(new ResourceLocation("elevatorid", "arrow"));
            BlockModelRotation rot = BlockModelRotation.m_119153_((int)0, (int)((int)((Direction)state.m_61143_((Property)ElevatorBlock.f_54117_)).m_122435_()));
            QuadTransformer transformer = new QuadTransformer(rot.m_6189_().blockCenterToCorner());
            result.addAll(transformer.processMany(arrowModel.getQuads(state, null, rand, extraData)));
        }
        if ((heldState = (BlockState)extraData.getData(HELD_STATE)) != null) {
            if (ItemBlockRenderTypes.canRenderInLayer((BlockState)heldState, (RenderType)layer)) {
                BakedModel model = dispatcher.m_110910_(heldState);
                result.addAll(model.getQuads(heldState, side, rand, extraData));
            }
            return result;
        }
        if (layer == RenderType.m_110451_() || layer == null) {
            result.addAll(this.originalModel.getQuads(state, side, rand, extraData));
        }
        return result;
    }

    @Nonnull
    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        BlockState state = (BlockState)data.getData(HELD_STATE);
        if (state != null) {
            return Minecraft.m_91087_().m_91289_().m_110910_(state).getParticleIcon(data);
        }
        return super.getParticleIcon(data);
    }
}

