/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLever;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.OpenBlocks;
import openmods.infobook.BookDocumentation;
import org.apache.commons.lang3.ArrayUtils;

@BookDocumentation
public class ItemWrench
extends Item {
    private final Set<Class<? extends Block>> sneakOnly = Sets.newIdentityHashSet();

    public ItemWrench() {
        this.func_77625_d(1);
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
        this.sneakOnly.add(BlockLever.class);
        this.sneakOnly.add(BlockButton.class);
        this.sneakOnly.add(BlockChest.class);
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    private boolean requiresSneaking(final Block block) {
        return Iterables.any(this.sneakOnly, (Predicate)new Predicate<Class<? extends Block>>(){

            public boolean apply(@Nullable Class<? extends Block> input) {
                return input.isInstance(block);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        if (this.requiresSneaking(block) && !player.func_70093_af()) {
            return false;
        }
        ForgeDirection rotationAxis = ForgeDirection.getOrientation((int)side);
        Object[] rotations = block.getValidRotations(world, x, y, z);
        if (ArrayUtils.contains((Object[])rotations, (Object)rotationAxis) && block.rotateBlock(world, x, y, z, rotationAxis)) {
            player.func_71038_i();
            return !world.field_72995_K;
        }
        return false;
    }
}

