/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.client.model.ModelPaintMixer;
import openblocks.common.tileentity.TileEntityPaintMixer;
import openmods.geometry.Orientation;
import openmods.utils.BlockUtils;
import openmods.utils.ColorUtils;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class TileEntityPaintMixerRenderer
extends TileEntitySpecialRenderer {
    RenderBlocks renderer = new RenderBlocks();
    private ModelPaintMixer model = new ModelPaintMixer();
    private static final ResourceLocation texture = new ResourceLocation("openblocks", "textures/models/paintmixer.png");
    private static final ColorUtils.RGB start = new ColorUtils.RGB();
    private static final ColorUtils.RGB end = new ColorUtils.RGB();
    private static final EnumSet<ForgeDirection> TOP_FACE = EnumSet.of(ForgeDirection.UP);
    private static final EnumSet<ForgeDirection> SIDES = EnumSet.complementOf(TOP_FACE);

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        TileEntityPaintMixer mixer = (TileEntityPaintMixer)tileentity;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.5f));
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glRotatef((float)(-BlockUtils.getRotationFromOrientation((Orientation)mixer.getOrientation())), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(texture);
        this.model.render((TileEntity)mixer, f);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.05, (double)0.5, (double)0.0);
        GL11.glRotated((double)150.0, (double)0.0, (double)0.0, (double)-1.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
        this.func_147499_a(TextureMap.field_110575_b);
        if (mixer.hasPaint()) {
            GL11.glPushMatrix();
            if (mixer.isEnabled()) {
                GL11.glTranslated((double)0.0, (double)(Math.random() * 0.2), (double)0.0);
            }
            int secondPass = mixer.getCanColor();
            if (mixer.isEnabled()) {
                double progress = (double)((Integer)mixer.getProgress().getValue()).intValue() / 300.0;
                secondPass = TileEntityPaintMixerRenderer.calculateColorFade(secondPass, (Integer)mixer.getColor().getValue(), progress);
            }
            RenderUtils.renderInventoryBlock((RenderBlocks)this.renderer, (Block)OpenBlocks.Blocks.paintCan, (int)0, (int)0xFFFFFF, SIDES);
            RenderUtils.renderInventoryBlock((RenderBlocks)this.renderer, (Block)OpenBlocks.Blocks.paintCan, (int)0, (int)secondPass, TOP_FACE);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private static int calculateColorFade(int a, int b, double magnitude) {
        start.setColor(a);
        end.setColor(b);
        return start.interpolate(end, magnitude).getColor();
    }
}

