/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class EntitySmoothMove
extends Entity {
    protected final MoveSmoother smoother;
    private boolean isPositionValid;

    public EntitySmoothMove(World world) {
        super(world);
        this.smoother = this.createSmoother(world.field_72995_K);
    }

    protected MoveSmoother createSmoother(boolean isRemote) {
        return isRemote ? new MoveSmoother(0.25, 1.0, 8.0, 0.01) : new MoveSmoother(0.5, 5.0, 128.0, 0.01);
    }

    private boolean isFullyInitialized() {
        return this.smoother != null;
    }

    private void setPositionRaw(double x, double y, double z) {
        this.isPositionValid = this.isFullyInitialized();
        super.func_70107_b(x, y, z);
    }

    public void func_70107_b(double x, double y, double z) {
        if (this.isFullyInitialized()) {
            this.smoother.setTarget(x, y, z);
        } else {
            this.setPositionRaw(x, y, z);
        }
    }

    protected void updatePrevPosition() {
        this.field_70141_P = this.field_70140_Q;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
    }

    public class MoveSmoother {
        private final double damp;
        private final double cutoff;
        private final double panicLengthSq;
        private final double minimalLengthSq;
        private double targetX;
        private double targetY;
        private double targetZ;

        public MoveSmoother(double damp, double cutoff, double panicLength, double minimalLength) {
            this.damp = damp;
            this.cutoff = cutoff;
            this.panicLengthSq = panicLength * panicLength;
            this.minimalLengthSq = minimalLength * minimalLength;
        }

        protected boolean shouldJump(double x, double y, double z) {
            double dx = x - EntitySmoothMove.this.field_70165_t;
            double dy = y - EntitySmoothMove.this.field_70163_u;
            double dz = z - EntitySmoothMove.this.field_70161_v;
            double lenSq = dx * dx + dy * dy + dz * dz;
            return this.shouldJump(lenSq);
        }

        private boolean shouldJump(double lenSq) {
            return lenSq > this.panicLengthSq || lenSq < this.minimalLengthSq;
        }

        public void setTarget(Vec3d position) {
            this.setTarget(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        }

        public void setTarget(double targetX, double targetY, double targetZ) {
            if (!EntitySmoothMove.this.isPositionValid || this.shouldJump(targetX, targetY, targetZ)) {
                EntitySmoothMove.this.setPositionRaw(targetX, targetY, targetZ);
                EntitySmoothMove.this.field_70179_y = 0.0;
                EntitySmoothMove.this.field_70181_x = 0.0;
                EntitySmoothMove.this.field_70159_w = 0.0;
            }
            this.targetX = targetX;
            this.targetY = targetY;
            this.targetZ = targetZ;
        }

        public void update() {
            double dx = this.targetX - EntitySmoothMove.this.field_70165_t;
            double dy = this.targetY - EntitySmoothMove.this.field_70163_u;
            double dz = this.targetZ - EntitySmoothMove.this.field_70161_v;
            double lenSq = dx * dx + dy * dy + dz * dz;
            if (this.shouldJump(lenSq)) {
                EntitySmoothMove.this.setPositionRaw(this.targetX, this.targetY, this.targetZ);
                EntitySmoothMove.this.field_70179_y = 0.0;
                EntitySmoothMove.this.field_70181_x = 0.0;
                EntitySmoothMove.this.field_70159_w = 0.0;
            } else {
                if (lenSq > this.cutoff * this.cutoff) {
                    double scale = this.cutoff / Math.sqrt(lenSq);
                    dx *= scale;
                    dy *= scale;
                    dz *= scale;
                }
                EntitySmoothMove.this.func_70091_d(MoverType.SELF, EntitySmoothMove.this.field_70159_w + dx * this.damp, EntitySmoothMove.this.field_70181_x + dy * this.damp, EntitySmoothMove.this.field_70179_y + dz * this.damp);
            }
        }
    }
}

