/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.scala;

import java.util.HashMap;
import net.machinemuse.numina.general.MuseLogger;

public class MuseBiMap<S, T> {
    private HashMap<S, T> nameMap = new HashMap();
    private HashMap<T, S> elemMap = new HashMap();

    public T get(S name) {
        return this.nameMap.get(name);
    }

    public Iterable<T> elems() {
        return this.nameMap.values();
    }

    public Iterable<S> names() {
        return this.elemMap.values();
    }

    public T putName(S name, T elem) {
        T value = this.nameMap.get(name);
        if (value != null) {
            MuseLogger.logError(name + " already a member!");
            return value;
        }
        this.nameMap.put(name, elem);
        this.elemMap.put(elem, name);
        return elem;
    }

    public S putElem(T elem, S name) {
        T value = this.nameMap.get(name);
        if (value != null) {
            MuseLogger.logError(name + " already a member!");
        } else {
            this.nameMap.put(name, elem);
            this.elemMap.put(elem, name);
        }
        return name;
    }

    public HashMap<S, T> apply() {
        return this.nameMap;
    }

    public HashMap<T, S> inverse() {
        return this.elemMap;
    }

    public S getName(T elem) {
        return this.elemMap.get(elem);
    }

    public S removeElem(T elem) {
        S name = this.getName(elem);
        if (name != null) {
            this.nameMap.remove(name);
            this.elemMap.remove(elem);
        }
        return name;
    }

    public T removeName(S name) {
        T value = this.get(name);
        if (value != null) {
            this.nameMap.remove(name);
            this.elemMap.remove(value);
        }
        return value;
    }
}

