/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.List;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.network.MusePackager;
import net.machinemuse.numina.network.MusePacket;
import net.machinemuse.numina.scala.MuseNumericRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;

@ChannelHandler.Sharable
public final class MusePacketHandler
extends MessageToMessageCodec<FMLProxyPacket, MusePacket> {
    public static String networkChannelName;
    public static MuseNumericRegistry<MusePackager> packagers;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;

    private MusePacketHandler() {
        networkChannelName = "Numina";
        packagers = new MuseNumericRegistry();
        channels = NetworkRegistry.INSTANCE.newChannel(networkChannelName, new ChannelHandler[]{this});
    }

    public void encode(ChannelHandlerContext ctx, MusePacket msg, List<Object> out) {
        try {
            out.add(msg.getFMLProxyPacket());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) {
        DataInputStream data = new DataInputStream((InputStream)new ByteBufInputStream(msg.payload()));
        int packetType = 0;
        INetHandler handler = msg.handler();
        try {
            if (handler instanceof NetHandlerPlayServer) {
                EntityPlayerMP player = ((NetHandlerPlayServer)handler).field_147369_b;
                packetType = data.readInt();
                MusePackager packagerServer = (MusePackager)packagers.get(packetType);
                MusePacket packetServer = packagerServer.read(data, (EntityPlayer)player);
                packetServer.handleServer(player);
            } else {
                if (!(handler instanceof NetHandlerPlayClient)) {
                    throw new IOException("Error with (INetHandler) handler. Should be instance of NetHandlerPlayClient.");
                }
                EntityPlayer player = this.getClientPlayer();
                packetType = data.readInt();
                MusePackager packagerClient = (MusePackager)packagers.get(packetType);
                MusePacket packetClient = packagerClient.read(data, player);
                packetClient.handleClient(player);
            }
        }
        catch (Exception exception) {
            MuseLogger.logException("PROBLEM READING PACKET IN DECODE STEP D:", exception);
        }
    }

    static {
        new MusePacketHandler();
    }
}

