/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PositionedStack {
    public int relx;
    public int rely;
    public ItemStack[] items;
    public ItemStack item;
    private boolean permutated = false;

    public PositionedStack(Object object, int x, int y, boolean genPerms) {
        this.items = NEIServerUtils.extractRecipeItems(object);
        this.relx = x;
        this.rely = y;
        if (genPerms) {
            this.generatePermutations();
        } else {
            this.setPermutationToRender(0);
        }
    }

    public PositionedStack(Object object, int x, int y) {
        this(object, x, y, true);
    }

    public void generatePermutations() {
        if (this.permutated) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack item : this.items) {
            if (item == null || item.func_77973_b() == null) continue;
            if (item.func_77960_j() == Short.MAX_VALUE) {
                List permutations = ItemList.itemMap.get((Object)item.func_77973_b());
                if (!permutations.isEmpty()) {
                    for (ItemStack stack : permutations) {
                        stacks.add(stack.func_77946_l());
                    }
                    continue;
                }
                ItemStack base = new ItemStack(item.func_77973_b(), item.field_77994_a);
                base.field_77990_d = item.field_77990_d;
                stacks.add(base);
                continue;
            }
            stacks.add(item.func_77946_l());
        }
        this.items = stacks.toArray(new ItemStack[0]);
        if (this.items.length == 0) {
            this.items = new ItemStack[]{new ItemStack((Block)Blocks.field_150480_ab)};
        }
        this.permutated = true;
        this.setPermutationToRender(0);
    }

    public void setMaxSize(int i) {
        for (ItemStack item : this.items) {
            if (item.field_77994_a <= i) continue;
            item.field_77994_a = i;
        }
    }

    public PositionedStack copy() {
        return new PositionedStack(this.items, this.relx, this.rely);
    }

    public void setPermutationToRender(int index) {
        this.item = this.items[index].func_77946_l();
        if (this.item.func_77973_b() == null) {
            this.item = new ItemStack((Block)Blocks.field_150480_ab);
        } else if (this.item.func_77960_j() == Short.MAX_VALUE) {
            this.item.func_77964_b(0);
        }
    }

    public boolean contains(ItemStack ingredient) {
        for (ItemStack item : this.items) {
            if (!NEIServerUtils.areStacksSameTypeCrafting(item, ingredient)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Item ingred) {
        for (ItemStack item : this.items) {
            if (item.func_77973_b() != ingred) continue;
            return true;
        }
        return false;
    }
}

