/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.handler;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.state.GlStateTracker;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.config.KeyBindings;
import codechicken.nei.guihook.IContainerDrawHandler;
import codechicken.nei.guihook.IContainerObjectHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.guihook.IInputHandler;
import codechicken.nei.network.NEIClientPacketHandler;
import codechicken.nei.util.helper.GuiHelper;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class NEIClientEventHandler {
    public static NEIClientEventHandler INSTANCE = new NEIClientEventHandler();
    public static final LinkedList<IInputHandler> inputHandlers = new LinkedList();
    public static final LinkedList<IContainerObjectHandler> objectHandlers = new LinkedList();
    public static final LinkedList<IContainerDrawHandler> drawHandlers = new LinkedList();
    public static final LinkedList<IContainerTooltipHandler> tooltipHandlers = new LinkedList();
    private static List<IContainerTooltipHandler> instanceTooltipHandlers;
    private static GuiScreen lastGui;

    public static void addInputHandler(IInputHandler handler) {
        inputHandlers.add(handler);
    }

    public static void addTooltipHandler(IContainerTooltipHandler handler) {
        tooltipHandlers.add(handler);
    }

    public static void addDrawHandler(IContainerDrawHandler handler) {
        drawHandlers.add(handler);
    }

    public static void addObjectHandler(IContainerObjectHandler handler) {
        objectHandlers.add(handler);
    }

    private NEIClientEventHandler() {
    }

    public void init() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onKeyTypedPre(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiContainer) {
            char c = Keyboard.getEventCharacter();
            int eventKey = Keyboard.getEventKey();
            if (eventKey == 0 && c >= ' ' || Keyboard.getEventKeyState()) {
                inputHandlers.forEach(handler -> handler.onKeyTyped(gui, c, eventKey));
                for (IInputHandler handler2 : inputHandlers) {
                    if (!handler2.keyTyped(gui, c, eventKey)) continue;
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void onKeyTypedPost(GuiScreenEvent.KeyboardInputEvent.Post event) {
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiContainer) {
            char c = Keyboard.getEventCharacter();
            int eventKey = Keyboard.getEventKey();
            if (eventKey == 0 && c >= ' ' || Keyboard.getEventKeyState()) {
                if (eventKey != 1) {
                    for (IInputHandler inputhander : inputHandlers) {
                        if (!inputhander.lastKeyTyped(gui, c, eventKey)) continue;
                        event.setCanceled(true);
                        return;
                    }
                }
                if (KeyBindings.get("nei.options.keys.gui.enchant").isActiveAndMatches(eventKey) && NEIClientConfig.canPerformAction("enchant")) {
                    NEIClientPacketHandler.sendOpenEnchantmentWindow();
                    event.setCanceled(true);
                }
                if (KeyBindings.get("nei.options.keys.gui.potion").isActiveAndMatches(eventKey) && NEIClientConfig.canPerformAction("potion")) {
                    NEIClientPacketHandler.sendOpenPotionWindow();
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseEventPre(GuiScreenEvent.MouseInputEvent.Pre event) {
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiContainer) {
            Point mousePos = GuiDraw.getMousePosition();
            int mouseButton = Mouse.getEventButton();
            if (Mouse.getEventButtonState()) {
                gui.field_146288_g = Minecraft.func_71386_F();
                inputHandlers.forEach(handler -> handler.onMouseClicked(gui, mousePos.x, mousePos.y, mouseButton));
                for (IInputHandler handler2 : inputHandlers) {
                    if (!handler2.mouseClicked(gui, mousePos.x, mousePos.y, mouseButton)) continue;
                    event.setCanceled(true);
                    return;
                }
            } else if (mouseButton != -1) {
                inputHandlers.forEach(handler -> handler.onMouseUp(gui, mousePos.x, mousePos.y, mouseButton));
            } else if (mouseButton != -1 && gui.field_146288_g > 0L) {
                long heldTime = Minecraft.func_71386_F() - gui.field_146288_g;
                inputHandlers.forEach(handler -> handler.onMouseDragged(gui, mousePos.x, mousePos.y, mouseButton, heldTime));
            }
        }
    }

    @SubscribeEvent
    public void onMouseEventPost(GuiScreenEvent.MouseInputEvent.Post event) {
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiContainer) {
            int i;
            Point mousePos = GuiDraw.getMousePosition();
            if (Mouse.getEventButtonState()) {
                int mouseButton = Mouse.getEventButton();
                inputHandlers.forEach(handler -> handler.onMouseClickedPost(gui, mousePos.x, mousePos.y, mouseButton));
            }
            if ((i = Mouse.getDWheel()) != 0) {
                int scrolled = i > 0 ? 1 : -1;
                for (IInputHandler handler2 : inputHandlers) {
                    if (!handler2.mouseScrolled(gui, mousePos.x, mousePos.y, scrolled)) continue;
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void potionShiftEvent(GuiScreenEvent.PotionShiftEvent event) {
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void containerInitEvent(GuiScreenEvent.InitGuiEvent.Pre event) {
        if (event.getGui() instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)event.getGui();
            objectHandlers.forEach(handler -> handler.load(container));
        }
    }

    @SubscribeEvent
    public void guiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiContainer && lastGui != event.getGui()) {
            if (event.getGui() == null) {
                instanceTooltipHandlers = null;
            } else {
                instanceTooltipHandlers = new LinkedList<IContainerTooltipHandler>();
                if (event.getGui() instanceof IContainerTooltipHandler) {
                    instanceTooltipHandlers.add((IContainerTooltipHandler)event.getGui());
                }
                instanceTooltipHandlers.addAll(tooltipHandlers);
            }
            lastGui = event.getGui();
        }
    }

    @SubscribeEvent
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft.field_71462_r instanceof GuiContainer) {
                objectHandlers.forEach(handler -> handler.guiTick((GuiContainer)minecraft.field_71462_r));
            }
        }
    }

    @SubscribeEvent
    public void drawScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiContainer container;
        GuiScreen screen = event.getGui();
        Point mousePos = GuiDraw.getMousePosition();
        LinkedList<String> tooltip = new LinkedList<String>();
        ItemStack stack = ItemStack.field_190927_a;
        if (instanceTooltipHandlers != null) {
            instanceTooltipHandlers.forEach(handler -> handler.handleTooltip(screen, mousePos.x, mousePos.y, tooltip));
        }
        if (screen instanceof GuiContainer && tooltip.isEmpty() && GuiHelper.shouldShowTooltip(screen) && !(stack = GuiHelper.getStackMouseOver(container = (GuiContainer)screen, false)).func_190926_b()) {
            tooltip.clear();
            tooltip.addAll(GuiHelper.itemDisplayNameMultiline(stack, container, false));
        }
        GuiDraw.drawMultiLineTip((ItemStack)stack, (int)(mousePos.x + 10), (int)(mousePos.y - 12), tooltip);
    }

    @SubscribeEvent
    public void foregroundRenderEvent(GuiContainerEvent.DrawForeground event) {
        GuiContainer container = event.getGuiContainer();
        GlStateTracker.pushState();
        Point mousePos = GuiDraw.getMousePosition();
        GlStateManager.func_179109_b((float)(-container.getGuiLeft()), (float)(-container.getGuiTop()), (float)100.0f);
        drawHandlers.forEach(handler -> handler.renderObjects(container, mousePos.x, mousePos.y));
        drawHandlers.forEach(handler -> handler.postRenderObjects(container, mousePos.x, mousePos.y));
        GlStateManager.func_179109_b((float)container.getGuiLeft(), (float)container.getGuiTop(), (float)-100.0f);
        GuiHelper.enable3DRender();
        GlStateManager.func_179094_E();
        for (Slot slot : container.field_147002_h.field_75151_b) {
            GlStateTracker.pushState();
            drawHandlers.forEach(handler -> handler.renderSlotOverlay(container, slot));
            GlStateTracker.popState();
        }
        GlStateManager.func_179121_F();
        GlStateTracker.popState();
    }

    @SubscribeEvent
    public void tooltipPreEvent(RenderTooltipEvent.Pre event) {
        event.setY(MathHelper.clip((int)event.getY(), (int)8, (int)(event.getScreenHeight() - 8)));
    }

    @SubscribeEvent
    public void itemTooltipEvent(ItemTooltipEvent event) {
        if (instanceTooltipHandlers != null && Minecraft.func_71410_x().field_71462_r != null) {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            instanceTooltipHandlers.forEach(handler -> handler.handleItemDisplayName(screen, event.getItemStack(), event.getToolTip()));
        }
    }
}

