/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.nethermetals.init;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.registry.CrusherRecipeRegistry;
import com.mcmoddev.lib.util.Config;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class Recipes {
    private static final Names NAME = Names.NETHERORE;

    public static void init() {
        Recipes.recipeWrapper("coal");
        Recipes.recipeWrapper("diamond");
        Recipes.recipeWrapper("emerald");
        Recipes.recipeWrapper("gold");
        Recipes.recipeWrapper("iron");
        Recipes.recipeWrapper("lapis");
        Recipes.recipeWrapper("redstone");
        if (Loader.isModLoaded((String)"basemetals")) {
            Materials.getMaterialsByMod((String)"basemetals").stream().forEach(mat -> Recipes.recipeWrapper(mat));
        }
        if (Loader.isModLoaded((String)"modernmetals")) {
            Materials.getMaterialsByMod((String)"modernmetals").stream().forEach(mat -> Recipes.recipeWrapper(mat));
        }
    }

    private static void recipeWrapper(MMDMaterial material) {
        if (!material.isEmpty() && material.hasBlock(NAME)) {
            Recipes.doFurnaceSmelting(material);
            Recipes.doMakeDusts(material);
        }
    }

    private static void recipeWrapper(String materialName) {
        MMDMaterial material;
        if (Materials.hasMaterial((String)materialName) && !(material = Materials.getMaterialByName((String)materialName)).isEmpty() && material.hasBlock(NAME)) {
            Recipes.doFurnaceSmelting(material);
            Recipes.doMakeDusts(material);
        }
    }

    private static void doMakeDusts(MMDMaterial material) {
        if (Config.Options.isThingEnabled((String)"makeDusts") && material.hasItem(Names.POWDER)) {
            CrusherRecipeRegistry.addNewCrusherRecipe((Block)material.getBlock(NAME), (ItemStack)material.getItemStack(Names.POWDER, 4));
        } else if (material.hasBlock(Names.ORE)) {
            CrusherRecipeRegistry.addNewCrusherRecipe((Block)material.getBlock(NAME), (ItemStack)material.getBlockItemStack(Names.ORE, 2));
        }
    }

    private static void doFurnaceSmelting(MMDMaterial material) {
        int outputQty = 2;
        float xp = 1.0f;
        if (Config.Options.isThingEnabled((String)"enableFurnaceSmelting")) {
            if (Config.Options.isThingEnabled((String)"smeltToIngots") && material.hasItem(Names.INGOT)) {
                GameRegistry.addSmelting((Block)material.getBlock(NAME), (ItemStack)material.getItemStack(Names.INGOT, 2), (float)1.0f);
            } else if (material.hasBlock(Names.ORE)) {
                GameRegistry.addSmelting((Block)material.getBlock(NAME), (ItemStack)material.getBlockItemStack(Names.ORE, 2), (float)1.0f);
            }
        }
    }

    private Recipes() {
        throw new IllegalAccessError("Not a instantiable class");
    }
}

