/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.nethermetals.init;

import com.mcmoddev.lib.block.BlockMMDNetherOre;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Blocks;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Oredicts;
import com.mcmoddev.nethermetals.init.ItemGroups;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;

public final class NetherBlocks
extends Blocks {
    public static void init() {
        List<String> knownMaterials = Arrays.asList("coal", "diamond", "emerald", "gold", "iron", "lapis", "redstone", "antimony", "bismuth", "copper", "lead", "mercury", "nickel", "platinum", "silver", "tin", "zinc", "aluminum", "cadmium", "chromium", "iridium", "magnesium", "manganese", "osmium", "plutonium", "rutile", "tantalum", "titanium", "tungsten", "uranium", "zirconium");
        Materials.getAllMaterials().stream().map(material -> material.getName()).filter(knownMaterials::contains).filter(Materials::hasMaterial).forEach(NetherBlocks::createOreWrapper);
    }

    private static void createOreWrapper(String materialName) {
        List<String> vanillaMats = Arrays.asList("coal", "diamond", "emerald", "gold", "iron", "lapis", "redstone");
        if (vanillaMats.contains(materialName)) {
            NetherBlocks.createVanillaOreWrapper(materialName);
        } else {
            NetherBlocks.create((Names)Names.NETHERORE, (String)materialName);
        }
    }

    private static void createVanillaOreWrapper(String materialName) {
        MMDMaterial material = Materials.getMaterialByName((String)materialName);
        material.addNewBlock(Names.NETHERORE, NetherBlocks.addBlock((Block)new BlockMMDNetherOre(material), (String)Names.NETHERORE.toString(), (MMDMaterial)material, (CreativeTabs)ItemGroups.getTab((String)"blocks")));
        Block block = material.getBlock(Names.NETHERORE);
        String oredict = NetherBlocks.getOredictFromName((Names)Names.NETHERORE);
        if (oredict != null && block != null) {
            Oredicts.registerOre((String)(oredict + material.getCapitalizedName()), (Block)block);
        }
    }
}

