/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mffs.prefab.node;

import com.builtbroken.mc.api.tile.access.IRotation;
import com.builtbroken.mc.framework.logic.TileNode;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class NodeMFFS
extends TileNode
implements IRotation {
    private boolean enabled;
    private boolean prevEnabled;
    private boolean redstone;
    private boolean prevRedstone;

    public NodeMFFS(String id) {
        super(id, "mffs");
    }

    public void update(long ticks) {
        super.update(ticks);
        if (ticks % 3L == 0L) {
            this.redstone = this.getHost().isRedstonePowered();
        }
        if (this.prevEnabled != this.enabled) {
            this.onActivationChanged();
        }
        if (this.prevRedstone != this.redstone) {
            this.onRedstoneChanged();
        }
        this.prevRedstone = this.redstone;
        this.prevEnabled = this.enabled;
    }

    protected void onActivationChanged() {
    }

    protected void onRedstoneChanged() {
    }

    public NBTTagCompound save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74757_a("enabled", this.enabled);
        return nbt;
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.enabled = nbt.func_74767_n("enabled");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean on) {
        this.enabled = on;
    }

    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)this.getHost().getHostMeta());
    }
}

