/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mffs.content.interdiction;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mffs.MFFS;
import com.builtbroken.mffs.MFFSSettings;
import com.builtbroken.mffs.api.card.ICardInfinite;
import com.builtbroken.mffs.api.modules.IFieldModule;
import com.builtbroken.mffs.api.modules.IInterdictionModule;
import com.builtbroken.mffs.api.security.IBiometricIdentifier;
import com.builtbroken.mffs.api.security.IInterdictionMatrix;
import com.builtbroken.mffs.api.security.Permission;
import com.builtbroken.mffs.api.vector.Vector3D;
import com.builtbroken.mffs.common.items.card.ItemCardFrequency;
import com.builtbroken.mffs.common.items.modules.interdiction.ItemModuleWarn;
import com.builtbroken.mffs.common.items.modules.upgrades.ItemModuleScale;
import com.builtbroken.mffs.common.net.packet.EntityToggle;
import com.builtbroken.mffs.content.projector.TileForceFieldProjector;
import com.builtbroken.mffs.prefab.ModuleInventory;
import com.builtbroken.mffs.prefab.tile.TileModuleAcceptor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public final class TileInterdictionMatrix
extends TileModuleAcceptor
implements IInterdictionMatrix {
    private static final int TICK_RATE = 20;
    private static ChatComponentText warning = new ChatComponentText("[InterdictionMatrix] " + LanguageUtility.getLocal((String)"message.interdictionMatrix.warn"));
    private boolean banMode;
    private TileForceFieldProjector projector;

    public TileInterdictionMatrix() {
        this.fortronCapacity = 30;
        this.moduleInventory = new ModuleInventory(this, 2, 9);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.isActive() && this.ticks % 20 == 0) {
            if (this.projector == null) {
                int count = 0;
                Pos pos = new Pos((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tile = ((Pos)pos.add(direction)).getTileEntity((IBlockAccess)this.field_145850_b);
                    if (!(tile instanceof TileForceFieldProjector)) continue;
                    ++count;
                    this.projector = (TileForceFieldProjector)tile;
                }
                if (count > 1) {
                    this.projector = null;
                }
            }
            if (this.requestFortron(this.getFortronCost() * 10, false) > 0) {
                this.requestFortron(this.getFortronCost() * 10, true);
                this.scan();
            }
        }
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.ticks > 12 && (this.projector == null || this.projector.isActive());
    }

    private void scan() {
        IBiometricIdentifier bio = this.getBiometricIdentifier();
        Cube warningRange = this.getWarningRange();
        Cube actionRange = this.getActionRange();
        Set<ItemStack> modules = this.getModuleStacks(new int[0]);
        boolean hasWarnModule = false;
        for (ItemStack stack : modules) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemModuleWarn)) continue;
            hasWarnModule = true;
            break;
        }
        if (modules != null && modules.size() > 0) {
            List entities = warningRange.getEntities(this.field_145850_b);
            for (Entity entity : entities) {
                boolean inField;
                boolean bl = inField = this.projector == null || this.projector.getInteriorPoints().contains(new Vector3D(entity).floor());
                if (actionRange.isWithin(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) && inField) {
                    IInterdictionModule mod;
                    ItemStack stack;
                    EntityPlayer player;
                    if (bio != null && entity instanceof EntityPlayer && (bio.isAccessGranted((player = (EntityPlayer)entity).func_146103_bH().getName(), Permission.BYPASS_DEFENSE) || player.field_71075_bZ.field_75098_d)) continue;
                    player = modules.iterator();
                    while (player.hasNext() && ((stack = (ItemStack)player.next()) == null || !(stack.func_77973_b() instanceof IInterdictionModule) || !(mod = (IInterdictionModule)stack.func_77973_b()).onDefend(this, entity) && !entity.field_70128_L)) {
                    }
                    continue;
                }
                if (!(entity instanceof EntityPlayer) || !hasWarnModule) continue;
                EntityPlayer pl = (EntityPlayer)entity;
                if (bio != null && bio.isAccessGranted(pl.func_146103_bH().getName(), Permission.BYPASS_DEFENSE)) continue;
                pl.func_145747_a((IChatComponent)warning);
            }
        }
    }

    @Override
    public Cube getWarningRange() {
        int range = Math.min(this.getModuleCount(ItemModuleWarn.class, new int[0]), MFFSSettings.INTERDICTION_MAX_RANGE) + 3;
        return this.getActionRange().expand(range);
    }

    @Override
    public Cube getActionRange() {
        if (this.projector != null) {
            Vector3D negScale = this.projector.getNegativeScale();
            Vector3D posScale = this.projector.getPositiveScale();
            Vector3D translation = this.projector.getTranslation();
            Vector3D pos = new Vector3D((double)this.projector.field_145851_c + 0.5, (double)this.projector.field_145848_d + 0.5, (double)this.projector.field_145849_e + 0.5);
            negScale = negScale.scale(-1.0).add(translation).add(pos);
            posScale = posScale.add(translation).add(pos);
            Pos start = new Pos(negScale.x, negScale.y, negScale.z);
            Pos end = new Pos(posScale.x, posScale.y, posScale.z);
            return new Cube((IPos3D)start, (IPos3D)end);
        }
        Pos center = new Pos((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
        int range = Math.min(this.getModuleCount(ItemModuleScale.class, new int[0]), MFFSSettings.INTERDICTION_MAX_RANGE);
        return new Cube((IPos3D)center.sub((double)range), (IPos3D)center.add((double)range));
    }

    @Override
    public IMessage handleMessage(IMessage imessage) {
        if (imessage instanceof EntityToggle) {
            EntityToggle tog = (EntityToggle)imessage;
            if (tog.toggle_opcode == 4) {
                this.banMode = !this.banMode;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return null;
            }
        }
        return super.handleMessage(imessage);
    }

    @Override
    public Set<ItemStack> getFilteredItems() {
        HashSet<ItemStack> stacks = new HashSet<ItemStack>();
        for (int i = this.moduleInventory.end; i < this.func_70302_i_() - 1; ++i) {
            if (this.func_70301_a(i) == null) continue;
            stacks.add(this.func_70301_a(i));
        }
        return stacks;
    }

    @Override
    public boolean getFilterMode() {
        return this.banMode;
    }

    @Override
    public float getAmplifier() {
        return 1.0f;
    }

    @Override
    public int func_70302_i_() {
        return 19;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("ban", this.banMode);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.banMode = nbt.func_74767_n("ban");
    }

    @Override
    public Set<ItemStack> getCards() {
        HashSet<ItemStack> cards = new HashSet<ItemStack>();
        cards.add(super.getCard());
        cards.add(this.func_70301_a(1));
        return cards;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot == 0) {
            return item.func_77973_b() instanceof ICardInfinite;
        }
        if (slot == 1) {
            return item.func_77973_b() instanceof ItemCardFrequency;
        }
        if (slot > this.moduleInventory.end) {
            return true;
        }
        return item.func_77973_b() instanceof IFieldModule;
    }

    @Override
    public List<ItemStack> getRemovedItems(EntityPlayer entityPlayer) {
        List<ItemStack> stack = super.getRemovedItems(entityPlayer);
        stack.add(new ItemStack(MFFS.interdictionMatrix));
        return stack;
    }
}

