/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mffs.content.gen;

import cofh.api.energy.IEnergyHandler;
import com.builtbroken.mc.api.energy.IEnergyBuffer;
import com.builtbroken.mc.api.energy.IEnergyBufferProvider;
import com.builtbroken.mc.framework.energy.UniversalEnergySystem;
import com.builtbroken.mc.framework.energy.data.AbstractEnergyBuffer;
import com.builtbroken.mffs.MFFS;
import com.builtbroken.mffs.MFFSSettings;
import com.builtbroken.mffs.api.modules.IFieldModule;
import com.builtbroken.mffs.common.items.card.ItemCardFrequency;
import com.builtbroken.mffs.common.items.modules.upgrades.ItemModuleScale;
import com.builtbroken.mffs.common.items.modules.upgrades.ItemModuleSpeed;
import com.builtbroken.mffs.prefab.ModuleInventory;
import com.builtbroken.mffs.prefab.tile.TileModuleAcceptor;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public final class TileCoercionDeriver
extends TileModuleAcceptor
implements IEnergyHandler,
IEnergyBufferProvider {
    public static final int SLOT_FREQUENCY = 0;
    public static final int SLOT_BATTERY = 1;
    public static final int SLOT_FUEL = 2;
    private CoercionEnergyBuffer energyBuffer;
    public int fuelTimer = 0;
    public boolean outputPower;

    public TileCoercionDeriver() {
        this.fortronCapacity = MFFSSettings.COERCION_FORTRON_TANK_SIZE;
        this.moduleInventory = new ModuleInventory(this, 3, this.func_70302_i_());
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isActive()) {
                if (this.outputPower && MFFSSettings.COERCION_USE_POWER) {
                    if (this.getBattery().getEnergyStored() < this.getBattery().getMaxBufferSize()) {
                        this.requestFortron(this.getFortronCreationRate(), true);
                        this.getBattery().addEnergyToStorage(this.getFortronCreationRate(), true);
                    }
                } else if (this.getFortronEnergy() + this.getFortronCreationRate() < this.getFortronCapacity() && this.canCreateFortron()) {
                    this.provideFortron(this.getFortronCreationRate(), true);
                    this.getBattery().removeEnergyFromStorage(this.getPowerUsage(), true);
                    if (this.fuelTimer == 0 && this.func_94041_b(2, this.func_70301_a(2))) {
                        this.func_70298_a(2, 1);
                        this.fuelTimer = 200 * Math.max(this.getModuleCount(ItemModuleScale.class, new int[0]) / 20, 1);
                    }
                    if (this.fuelTimer > 0) {
                        --this.fuelTimer;
                    }
                }
            }
        } else if (this.isActive()) {
            this.animation += 1.0f;
        }
    }

    protected boolean canCreateFortron() {
        return !MFFSSettings.COERCION_USE_POWER && this.func_94041_b(2, this.func_70301_a(2)) || this.getBattery().getEnergyStored() >= this.getPowerUsage();
    }

    public int getFortronCreationRate() {
        if (this.isActive()) {
            int fortron = MFFSSettings.COERCION_OUTPUT_PER_TICK + MFFSSettings.COERCION_OUTPUT_PER_TICK * this.getModuleCount(ItemModuleSpeed.class, new int[0]);
            if (this.fuelTimer > 0) {
                fortron *= MFFSSettings.COERCION_FUEL_BONUS;
            }
            return fortron;
        }
        return 0;
    }

    @Override
    public int func_70302_i_() {
        return 6;
    }

    @Override
    public List<ItemStack> getRemovedItems(EntityPlayer entityPlayer) {
        List<ItemStack> stack = super.getRemovedItems(entityPlayer);
        stack.add(new ItemStack(MFFS.coercionDeriver));
        return stack;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (itemStack != null) {
            if (slotID >= this.moduleInventory.start) {
                return itemStack.func_77973_b() instanceof IFieldModule;
            }
            switch (slotID) {
                case 0: {
                    return itemStack.func_77973_b() instanceof ItemCardFrequency;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return itemStack.func_77973_b() == Items.field_151100_aR && itemStack.func_77960_j() == 4 || itemStack.func_77973_b() == Items.field_151128_bU;
                }
            }
        }
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("process", this.fuelTimer);
        nbt.func_74757_a("inverse", this.outputPower);
        if (this.energyBuffer != null) {
            nbt.func_74768_a("energy", this.energyBuffer.getEnergyStored());
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fuelTimer = nbt.func_74762_e("process");
        this.outputPower = nbt.func_74767_n("inverse");
        this.getBattery().setEnergyStored(nbt.func_74762_e("energy"));
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        IEnergyBuffer buffer = this.getEnergyBuffer(from);
        if (buffer != null) {
            maxReceive = Math.min(this.getTransferLimit(), UniversalEnergySystem.RF_HANDLER.toUEEnergy(maxReceive));
            int received = buffer.addEnergyToStorage(maxReceive, !simulate);
            return UniversalEnergySystem.RF_HANDLER.fromUE(received);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        IEnergyBuffer buffer = this.getEnergyBuffer(from);
        if (buffer != null) {
            maxExtract = Math.min(this.getTransferLimit(), UniversalEnergySystem.RF_HANDLER.toUEEnergy(maxExtract));
            int extracted = buffer.removeEnergyFromStorage(maxExtract, !simulate);
            return UniversalEnergySystem.RF_HANDLER.fromUE(extracted);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        IEnergyBuffer buffer = this.getEnergyBuffer(from);
        if (buffer != null) {
            return UniversalEnergySystem.RF_HANDLER.fromUE(buffer.getEnergyStored());
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return UniversalEnergySystem.RF_HANDLER.fromUE(this.getBattery().getMaxBufferSize());
    }

    protected int getTransferLimit() {
        return Math.round((float)this.getBattery().getMaxBufferSize() * MFFSSettings.COERCION_BATTERY_TRANSFER_PERCENTAGE);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return MFFSSettings.COERCION_USE_POWER;
    }

    public CoercionEnergyBuffer getBattery() {
        if (this.energyBuffer == null) {
            this.energyBuffer = new CoercionEnergyBuffer(this);
        }
        return this.energyBuffer;
    }

    public int getPowerUsage() {
        return MFFSSettings.COERCION_POWER_COST + MFFSSettings.COERCION_POWER_COST * this.getModuleCount(ItemModuleSpeed.class, new int[0]);
    }

    public IEnergyBuffer getEnergyBuffer(ForgeDirection side) {
        return this.energyBuffer;
    }

    public static class CoercionEnergyBuffer
    extends AbstractEnergyBuffer {
        protected TileCoercionDeriver host;

        public CoercionEnergyBuffer(TileCoercionDeriver host) {
            this.host = host;
        }

        public int addEnergyToStorage(int energy, boolean doAction) {
            if (MFFSSettings.COERCION_USE_POWER) {
                return super.addEnergyToStorage(energy, doAction);
            }
            return 0;
        }

        public int getMaxBufferSize() {
            return MFFSSettings.COERCION_BATTERY_SIZE;
        }
    }
}

