/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mffs.common.items.modules.projector.mode;

import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mffs.api.IFieldInteraction;
import com.builtbroken.mffs.api.IProjector;
import com.builtbroken.mffs.api.render.ModelCube;
import com.builtbroken.mffs.api.vector.Vector3D;
import com.builtbroken.mffs.prefab.item.ItemMode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class ItemModeCylinder
extends ItemMode
implements IRecipeContainer {
    public void genRecipes(List<IRecipe> list) {
        list.add(this.newShapedRecipe(this, new Object[]{"F  ", "F  ", "F  ", Character.valueOf('F'), Item.field_150901_e.func_82594_a("mffs:focusMatrix")}));
    }

    @Override
    public Set<Vector3D> getExteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3D> fieldBlocks = new HashSet<Vector3D>();
        Vector3D posScale = projector.getPositiveScale();
        Vector3D negScale = projector.getNegativeScale();
        int radius = (posScale.intX() + negScale.intX() + posScale.intZ() + negScale.intZ()) / 2;
        int height = posScale.intY() + negScale.intY();
        for (float x = (float)(-radius); x <= (float)radius; x += 1.0f) {
            for (float z = (float)(-radius); z <= (float)radius; z += 1.0f) {
                for (float y = 0.0f; y < (float)height; y += 1.0f) {
                    if ((y == 0.0f || y == (float)(height - 1)) && x * x + z * z + 0.0f <= (float)(radius * radius)) {
                        fieldBlocks.add(new Vector3D(x, y, z));
                    }
                    if (!(x * x + z * z + 0.0f <= (float)(radius * radius)) || !(x * x + z * z + 0.0f >= (float)((radius - 1) * (radius - 1)))) continue;
                    fieldBlocks.add(new Vector3D(x, y, z));
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set<Vector3D> getInteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3D> fieldBlocks = new HashSet<Vector3D>();
        Vector3D translation = projector.getTranslation();
        Vector3D posScale = projector.getPositiveScale();
        Vector3D negScale = projector.getNegativeScale();
        int radius = (posScale.intX() + negScale.intX() + posScale.intZ() + negScale.intZ()) / 2;
        int height = posScale.intY() + negScale.intY();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y < height; ++y) {
                    Vector3D position = new Vector3D(x, y, z);
                    if (!this.isInField(projector, Vector3D.translate(position, new Vector3D((TileEntity)projector)).add(translation))) continue;
                    fieldBlocks.add(position);
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(IFieldInteraction projector, Vector3D position) {
        Vector3D posScale = projector.getPositiveScale();
        Vector3D negScale = projector.getNegativeScale();
        int radius = (posScale.intX() + negScale.intX() + posScale.intZ() + negScale.intZ()) / 2;
        Vector3D projectorPos = new Vector3D((TileEntity)projector);
        projectorPos.add(projector.getTranslation());
        Vector3D relativePosition = position.clone().subtract(projectorPos);
        relativePosition.rotate((double)(-projector.getRotationYaw()), -projector.getRotationPitch());
        return relativePosition.x * relativePosition.x + relativePosition.z * relativePosition.z <= (double)(radius * radius);
    }

    @Override
    public void render(IProjector projector, double x, double y, double z, float f, long ticks) {
        float scale = 0.15f;
        float detail = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        float radius = 1.5f;
        int i = 0;
        for (float renderX = -radius; renderX <= radius; renderX += detail) {
            for (float renderZ = -radius; renderZ <= radius; renderZ += detail) {
                for (float renderY = -radius; renderY <= radius; renderY += detail) {
                    if (!(renderX * renderX + renderZ * renderZ + 0.0f <= radius * radius && renderX * renderX + renderZ * renderZ + 0.0f >= (radius - 1.0f) * (radius - 1.0f)) && (renderY != 0.0f && renderY != radius - 1.0f || !(renderX * renderX + renderZ * renderZ + 0.0f <= radius * radius))) continue;
                    if (i % 2 == 0) {
                        Vector3D vector = new Vector3D(renderX, renderY, renderZ);
                        GL11.glTranslated((double)vector.x, (double)vector.y, (double)vector.z);
                        ModelCube.INSTNACE.render();
                        GL11.glTranslated((double)(-vector.x), (double)(-vector.y), (double)(-vector.z));
                    }
                    ++i;
                }
            }
        }
    }
}

