/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.recipe.factories;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.util.Config;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ConfigVariedOutput
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        String confKey = JsonUtils.func_151200_h((JsonObject)json, (String)"config_key");
        int resAmount = 0;
        switch (confKey) {
            case "gear": {
                resAmount = Config.Options.gearQuantity();
                break;
            }
            case "plate": {
                resAmount = Config.Options.plateQuantity();
                break;
            }
            case "rod": {
                resAmount = Config.Options.rodQuantity();
                break;
            }
            default: {
                MMDLib.logger.error("Unknown quantity config value {}, setting to 1", (Object)confKey);
                resAmount = 1;
            }
        }
        HashMap ingMap = Maps.newHashMap();
        JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet().stream().filter(ent -> ((String)ent.getKey()).length() == 1 && !((String)ent.getKey()).isEmpty()).forEach(ent -> ingMap.put(Character.valueOf(((String)ent.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)ent.getValue()), (JsonContext)context)));
        ingMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
        JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
        if (patternJ.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allows");
        }
        String[] pattern = new String[patternJ.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
            }
            pattern[x] = line;
        }
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = pattern[0].length();
        primer.height = pattern.length;
        primer.mirrored = true;
        primer.input = NonNullList.func_191197_a((int)(primer.width * primer.height), (Object)Ingredient.field_193370_a);
        HashSet keys = Sets.newHashSet(ingMap.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (String line : pattern) {
            for (char chr : line.toCharArray()) {
                Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                primer.input.set(x++, (Object)ing);
                keys.remove(Character.valueOf(chr));
            }
        }
        if (!keys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
        }
        String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
        result.func_190920_e(resAmount);
        return new ShapedOreRecipe(group.isEmpty() ? null : new ResourceLocation(group), result, primer);
    }
}

