/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.recipe;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ToolReturnRecipe
extends ShapelessOreRecipe {
    private final ItemStack theTool;
    private final List<ItemStack> ingredients;

    public ToolReturnRecipe(ResourceLocation ident, ItemStack tool, ItemStack result, ItemStack ... ingredients) {
        super(ident, result, (Object[])ingredients);
        this.theTool = tool;
        this.ingredients = Lists.newArrayList((Object[])ingredients);
    }

    private boolean itemStackMatches(ItemStack left, ItemStack right) {
        return left.func_77973_b().equals(right.func_77973_b()) && (left.func_77960_j() == Short.MAX_VALUE || left.func_77960_j() == right.func_77960_j());
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        Map<ItemStack, Boolean> matches = this.ingredients.stream().collect(Collectors.toMap(x -> x, x -> false));
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack k;
            ItemStack slot = inv.func_70301_a(i);
            if (!matches.keySet().stream().anyMatch(x -> this.itemStackMatches((ItemStack)x, slot)) || (k = matches.keySet().stream().filter(x -> this.itemStackMatches((ItemStack)x, slot)).distinct().findFirst().orElse(ItemStack.field_190927_a)).func_190926_b()) continue;
            matches.put(k, true);
        }
        return !matches.containsValue(false);
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList remnants = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (OreDictionary.itemMatches((ItemStack)inv.func_70301_a(i), (ItemStack)this.theTool, (boolean)false)) {
                ItemStack recipeTool = inv.func_70301_a(i);
                recipeTool.func_77972_a(1, null);
                remnants.set(i, (Object)recipeTool);
                continue;
            }
            remnants.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)inv.func_70301_a(i)));
        }
        return remnants;
    }
}

