/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.proxy;

import com.mcmoddev.lib.client.registrations.RegistrationHelper;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Blocks;
import com.mcmoddev.lib.init.Fluids;
import com.mcmoddev.lib.init.Items;
import com.mcmoddev.lib.network.MMDMessages;
import com.mcmoddev.lib.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockSlab;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MMDMessages.client_init();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (String name : Items.getItemRegistry().keySet()) {
            if (name.endsWith(Names.ANVIL.toString())) continue;
            RegistrationHelper.registerItemRender(name);
        }
        for (String name : Blocks.getBlockRegistry().keySet()) {
            RegistrationHelper.registerBlockRender(name);
        }
        for (String name : Fluids.getFluidBlockRegistry().keySet()) {
            RegistrationHelper.registerFluidRender(name);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        for (String name : Items.getItemRegistry().keySet()) {
            this.registerRenderOuter(Items.getItemByName(name));
        }
        for (String name : Blocks.getBlockRegistry().keySet()) {
            this.registerRenderOuter(Blocks.getBlockByName(name));
        }
    }

    private void registerRenderOuter(Item item) {
        if (item != null) {
            this.registerRender(item, Items.getNameOfItem(item));
        }
    }

    private void registerRenderOuter(Block block) {
        if (block instanceof BlockDoor || block instanceof BlockSlab) {
            return;
        }
        if (block != null) {
            this.registerRender(Item.func_150898_a((Block)block), Blocks.getNameOfBlock(block));
        }
    }

    public void registerRender(Item item, String name) {
        String resourceDomain = item.getRegistryName().func_110624_b();
        ResourceLocation resLoc = new ResourceLocation(resourceDomain, name);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(resLoc, "inventory"));
    }
}

