/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.item;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.item.MMDItemHelper;
import com.mcmoddev.lib.material.IMMDObject;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemMMDHoe
extends ItemHoe
implements IMMDObject {
    private final MMDMaterial material;
    private final Set<String> toolTypes;

    public ItemMMDHoe(MMDMaterial material) {
        super(Materials.getToolMaterialFor(material));
        this.material = material;
        this.func_77656_e(this.material.getToolDurability());
        this.toolTypes = new HashSet<String>();
        this.toolTypes.add(Names.HOE.toString());
    }

    public boolean func_82789_a(ItemStack intputItem, ItemStack repairMaterial) {
        return MMDItemHelper.isToolRepairable(repairMaterial, this.material.getCapitalizedName());
    }

    @Deprecated
    public int getHarvestLevel(ItemStack stack, @Nullable String typeRequested, EntityPlayer player, IBlockState blockState) {
        if (typeRequested != null && this.toolTypes.contains(typeRequested)) {
            return this.material.getToolHarvestLevel();
        }
        return -1;
    }

    public Set<String> getToolClasses(ItemStack item) {
        return this.toolTypes;
    }

    public float func_150893_a(ItemStack tool, IBlockState target) {
        if (this.canHarvestBlock(target, tool)) {
            return Math.max(1.0f, this.material.getToolEfficiency());
        }
        return 1.0f;
    }

    public boolean func_77644_a(ItemStack item, EntityLivingBase target, EntityLivingBase attacker) {
        super.func_77644_a(item, target, attacker);
        if (this.getMMDMaterial().hasEffect(item, target)) {
            this.getMMDMaterial().applyEffect(item, target);
        }
        return true;
    }

    public boolean func_150897_b(IBlockState target) {
        if (this.toolTypes.contains(target.func_177230_c().getHarvestTool(target))) {
            return this.material.getToolHarvestLevel() >= target.func_177230_c().getHarvestLevel(target);
        }
        return false;
    }

    public void func_77622_d(ItemStack item, World world, EntityPlayer crafter) {
        super.func_77622_d(item, world, crafter);
        if (this.getMMDMaterial().hasEffect(item, crafter)) {
            this.getMMDMaterial().applyEffect(item, crafter);
        }
    }

    public void func_77663_a(ItemStack item, World world, Entity player, int inventoryIndex, boolean isHeld) {
        MMDItemHelper.doRegeneration(item, world, isHeld, this.material.regenerates());
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        List<String> tt = this.getMMDMaterial().getTooltipFor(Names.HOE);
        if (!tt.isEmpty()) {
            tooltip.addAll(tt);
        }
    }

    @Override
    public MMDMaterial getMMDMaterial() {
        return this.material;
    }

    public String func_77842_f() {
        return this.material.getName();
    }
}

