/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Config;
import javax.annotation.Nonnull;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.common.recipe.RecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class Mekanism
implements IIntegration {
    public static final String PLUGIN_MODID = "mekanism";

    @Override
    public void init() {
        if (!Config.Options.isModEnabled(PLUGIN_MODID)) {
            return;
        }
    }

    protected static void addGassesForMaterial(@Nonnull String materialName) {
        if (!Materials.hasMaterial(materialName) || Materials.getMaterialByName(materialName).isEmpty()) {
            return;
        }
        Mekanism.addGassesForMaterial(Materials.getMaterialByName(materialName));
    }

    protected static void addGassesForMaterial(@Nonnull MMDMaterial material) {
        if (material.getFluid() == null) {
            return;
        }
        Gas gas1 = new Gas(material.getName(), material.getFluid().getStill().toString());
        gas1.setUnlocalizedName("gas" + material.getCapitalizedName());
        GasRegistry.register((Gas)gas1);
        Gas gas2 = new Gas(Mekanism.makeCleanGasName(material), material.getFluid().getStill().toString());
        gas2.setUnlocalizedName("cleanGas" + material.getCapitalizedName());
        GasRegistry.register((Gas)gas2);
    }

    private static String makeCleanGasName(@Nonnull MMDMaterial material) {
        return "clean" + material.getName();
    }

    protected static void addOreMultiplicationRecipes(@Nonnull String materialName) {
        Mekanism.addOreMultiplicationRecipes(Materials.getMaterialByName(materialName));
    }

    protected static void addOreMultiplicationRecipes(@Nonnull MMDMaterial material) {
        ItemStack clump = material.getItemStack(Names.CLUMP);
        ItemStack powderDirty = material.getItemStack(Names.POWDER_DIRTY);
        ItemStack ingot = material.getItemStack(Names.INGOT);
        ItemStack powder = material.getItemStack(Names.POWDER);
        ItemStack ore = material.getBlockItemStack(Names.ORE);
        ItemStack shard = material.getItemStack(Names.SHARD);
        ItemStack crystal = material.getItemStack(Names.CRYSTAL);
        String cleanGas = Mekanism.makeCleanGasName(material);
        Mekanism.addCrusherRecipe(clump, powderDirty);
        Mekanism.addCrusherRecipe(ingot, powder);
        Mekanism.addEnrichmentChamberRecipe(ore, new ItemStack(powder.func_77973_b(), 2));
        Mekanism.addEnrichmentChamberRecipe(powderDirty, powder);
        Mekanism.addPurificationChamberRecipe(ore, new ItemStack(clump.func_77973_b(), 3));
        Mekanism.addPurificationChamberRecipe(shard, clump);
        Mekanism.addChemicalInjectionChamberRecipe(ore, new ItemStack(shard.func_77973_b(), 4));
        Mekanism.addChemicalInjectionChamberRecipe(crystal, shard);
        Mekanism.addChemicalCrystallizerRecipe(cleanGas, 200, crystal);
        Mekanism.addChemicalWasherRecipe(material.getName(), cleanGas);
        Mekanism.addChemicalDissolutionChamberRecipe(ore, material.getName());
    }

    protected static void addMetallurgicInfuserRecipe(@Nonnull String infuse, @Nonnull int amount, @Nonnull ItemStack inputItem, @Nonnull ItemStack outputItem) {
        InfuseType infuseType = InfuseRegistry.get((String)infuse);
        RecipeHandler.addMetallurgicInfuserRecipe((InfuseType)infuseType, (int)amount, (ItemStack)inputItem, (ItemStack)outputItem);
    }

    protected static void addCrusherRecipe(@Nonnull ItemStack inputItem, @Nonnull ItemStack outputItem) {
        if (inputItem.func_190926_b() || outputItem.func_190926_b()) {
            return;
        }
        RecipeHandler.addCrusherRecipe((ItemStack)inputItem, (ItemStack)outputItem);
    }

    protected static void addEnrichmentChamberRecipe(@Nonnull ItemStack inputItem, @Nonnull ItemStack outputItem) {
        if (inputItem.func_190926_b() || outputItem.func_190926_b()) {
            return;
        }
        RecipeHandler.addEnrichmentChamberRecipe((ItemStack)inputItem, (ItemStack)outputItem);
    }

    protected static void addPurificationChamberRecipe(@Nonnull ItemStack inputItem, @Nonnull ItemStack outputItem) {
        if (inputItem.func_190926_b() || outputItem.func_190926_b()) {
            return;
        }
        RecipeHandler.addPurificationChamberRecipe((ItemStack)inputItem, (ItemStack)outputItem);
    }

    protected static void addChemicalInjectionChamberRecipe(@Nonnull ItemStack inputItem, @Nonnull ItemStack outputItem) {
        if (inputItem.func_190926_b() || outputItem.func_190926_b()) {
            return;
        }
        Gas inputGas = GasRegistry.getGas((String)"hydrogenChloride");
        RecipeHandler.addChemicalInjectionChamberRecipe((ItemStack)inputItem, (Gas)inputGas, (ItemStack)outputItem);
    }

    protected static void addChemicalCrystallizerRecipe(@Nonnull String inputGas, @Nonnull int inputGasQty, @Nonnull ItemStack outputItem) {
        if (outputItem.func_190926_b() || !GasRegistry.containsGas((String)inputGas)) {
            return;
        }
        GasStack inputGasStack = new GasStack(GasRegistry.getGas((String)inputGas), inputGasQty);
        RecipeHandler.addChemicalCrystallizerRecipe((GasStack)inputGasStack, (ItemStack)outputItem);
    }

    protected static void addChemicalWasherRecipe(@Nonnull String inputGas, @Nonnull String outputGas) {
        GasStack inputGasStack = new GasStack(GasRegistry.getGas((String)inputGas), 1);
        GasStack outputGasStack = new GasStack(GasRegistry.getGas((String)outputGas), 1);
        RecipeHandler.addChemicalWasherRecipe((GasStack)inputGasStack, (GasStack)outputGasStack);
    }

    protected static void addChemicalDissolutionChamberRecipe(@Nonnull ItemStack inputItem, @Nonnull String outputGas, @Nonnull int outputQty) {
        if (inputItem.func_190926_b()) {
            return;
        }
        GasStack outputGasStack = new GasStack(GasRegistry.getGas((String)outputGas), outputQty);
        RecipeHandler.addChemicalDissolutionChamberRecipe((ItemStack)inputItem, (GasStack)outputGasStack);
    }

    protected static void addChemicalDissolutionChamberRecipe(@Nonnull ItemStack inputItem, @Nonnull String outputGas) {
        if (inputItem.func_190926_b() || !GasRegistry.containsGas((String)outputGas)) {
            return;
        }
        Mekanism.addChemicalDissolutionChamberRecipe(inputItem, outputGas, 1000);
    }

    protected static void addPRCRecipe(@Nonnull ItemStack inputItem, @Nonnull FluidStack inputFluid, @Nonnull String inputGas, @Nonnull int inputGasQty, @Nonnull ItemStack outputItem, @Nonnull String outputGas, @Nonnull int outputGasQty, int extraEnergy, int ticks) {
        if (inputItem.func_190926_b()) {
            return;
        }
        GasStack inputGasStack = new GasStack(GasRegistry.getGas((String)inputGas), inputGasQty);
        GasStack outputGasStack = new GasStack(GasRegistry.getGas((String)outputGas), outputGasQty);
        RecipeHandler.addPRCRecipe((ItemStack)inputItem, (FluidStack)inputFluid, (GasStack)inputGasStack, (ItemStack)outputItem, (GasStack)outputGasStack, (double)extraEnergy, (int)ticks);
    }

    protected static void addPRCRecipe(@Nonnull ItemStack inputItem, @Nonnull FluidStack inputFluid, @Nonnull String inputGas, @Nonnull int inputGasQty, @Nonnull ItemStack outputItem, @Nonnull String outputGas, @Nonnull int outputGasQty) {
        Mekanism.addPRCRecipe(inputItem, inputFluid, inputGas, inputGasQty, outputItem, outputGas, outputGasQty, 0, 60);
    }

    protected static void addOsmiumCompressorRecipe(@Nonnull ItemStack inputItem, @Nonnull ItemStack outputItem) {
        if (inputItem.func_190926_b() || outputItem.func_190926_b()) {
            return;
        }
        RecipeHandler.addOsmiumCompressorRecipe((ItemStack)inputItem, (ItemStack)outputItem);
    }

    protected static void addCombinerRecipe(@Nonnull ItemStack inputItem, @Nonnull ItemStack outputItem) {
        if (inputItem.func_190926_b() || outputItem.func_190926_b()) {
            return;
        }
        RecipeHandler.addCombinerRecipe((ItemStack)inputItem, (ItemStack)outputItem);
    }

    protected static void addChemicalOxidizerRecipe(@Nonnull ItemStack inputItem, @Nonnull String outputGas, @Nonnull int outputGasQty) {
        if (inputItem.func_190926_b()) {
            return;
        }
        GasStack outputGasStack = new GasStack(GasRegistry.getGas((String)outputGas), outputGasQty);
        RecipeHandler.addChemicalOxidizerRecipe((ItemStack)inputItem, (GasStack)outputGasStack);
    }

    protected static void addChemicalInfuserRecipe(@Nonnull String leftInputGas, @Nonnull int leftInputGasQty, @Nonnull String rightInputGas, @Nonnull int rightInputGasQty, @Nonnull String outputGas, @Nonnull int outputGasQty) {
        GasStack leftInputGasStack = new GasStack(GasRegistry.getGas((String)leftInputGas), leftInputGasQty);
        GasStack rightInputGasStack = new GasStack(GasRegistry.getGas((String)rightInputGas), rightInputGasQty);
        GasStack outputGasStack = new GasStack(GasRegistry.getGas((String)outputGas), outputGasQty);
        RecipeHandler.addChemicalInfuserRecipe((GasStack)leftInputGasStack, (GasStack)rightInputGasStack, (GasStack)outputGasStack);
    }

    protected static void addPrecisionSawmillRecipe(@Nonnull ItemStack inputItem, @Nonnull ItemStack outputItem) {
        if (inputItem.func_190926_b() || outputItem.func_190926_b()) {
            return;
        }
        RecipeHandler.addPrecisionSawmillRecipe((ItemStack)inputItem, (ItemStack)outputItem);
    }

    protected static void addPrecisionSawmillRecipe(@Nonnull ItemStack inputItem, @Nonnull ItemStack mainOutput, @Nonnull ItemStack secondaryOutput, @Nonnull double chance) {
        if (inputItem.func_190926_b() || mainOutput.func_190926_b()) {
            return;
        }
        RecipeHandler.addPrecisionSawmillRecipe((ItemStack)inputItem, (ItemStack)mainOutput, (ItemStack)secondaryOutput, (double)chance);
    }

    protected static void addElectrolyticSeparatorRecipe(@Nonnull String inputFluidName, @Nonnull int inputFluidQty, @Nonnull String leftOutputGas, @Nonnull int leftOutputGasQty, @Nonnull String rightOutputGas, @Nonnull int rightOutputGasQty, @Nonnull int energy) {
        FluidStack inputFluid = new FluidStack(FluidRegistry.getFluid((String)inputFluidName), inputFluidQty);
        GasStack leftOutput = new GasStack(GasRegistry.getGas((String)leftOutputGas), leftOutputGasQty);
        GasStack rightOutput = new GasStack(GasRegistry.getGas((String)rightOutputGas), rightOutputGasQty);
        RecipeHandler.addElectrolyticSeparatorRecipe((FluidStack)inputFluid, (double)energy, (GasStack)leftOutput, (GasStack)rightOutput);
    }

    protected static void addThermalEvaporationRecipe(@Nonnull String inputFluidName, @Nonnull int inputFluidQty, @Nonnull String outputFluidName, @Nonnull int outputFluidQty) {
        FluidStack inputFluid = new FluidStack(FluidRegistry.getFluid((String)inputFluidName), inputFluidQty);
        FluidStack outputFluid = new FluidStack(FluidRegistry.getFluid((String)outputFluidName), outputFluidQty);
        RecipeHandler.addThermalEvaporationRecipe((FluidStack)inputFluid, (FluidStack)outputFluid);
    }

    protected static void addSolarNeutronRecipe(@Nonnull String inputGas, @Nonnull int inputGasQty, @Nonnull String outputGas, @Nonnull int outputGasQty) {
        GasStack inputGasStack = new GasStack(GasRegistry.getGas((String)inputGas), inputGasQty);
        GasStack outputGasStack = new GasStack(GasRegistry.getGas((String)outputGas), outputGasQty);
        RecipeHandler.addSolarNeutronRecipe((GasStack)inputGasStack, (GasStack)outputGasStack);
    }

    protected static boolean gasExists(@Nonnull String gasName) {
        return GasRegistry.containsGas((String)gasName);
    }
}

